/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class FourOhFourErrorLoggingFilter
extends HttpFilter {
    private static final Logger log = LoggerFactory.getLogger(FourOhFourErrorLoggingFilter.class);

    public void doFilter(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponseWrapper withLogging = new HttpServletResponseWrapper(this, servletResponse){

            public void setStatus(int sc) {
                if (log.isDebugEnabled() && sc == 404) {
                    Throwable t = new Throwable();
                    log.debug("404 code set ", t);
                }
                super.setStatus(sc);
            }

            public void sendError(int sc, String msg) throws IOException {
                if (log.isDebugEnabled() && sc == 404) {
                    Throwable t = new Throwable();
                    log.debug("404 error sent with message {}", (Object)msg, (Object)t);
                }
                super.sendError(sc, msg);
            }

            public void sendError(int sc) throws IOException {
                if (log.isDebugEnabled() && sc == 404) {
                    Throwable t = new Throwable();
                    log.debug("404 error sent ", t);
                }
                super.sendError(sc);
            }
        };
        filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)withLogging);
    }
}

