/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.impl.ratelimiter.ActionRateLimiter;
import com.atlassian.confluence.security.CaptchaManager;
import com.atlassian.spring.container.ContainerManager;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.image.ImageCaptchaService;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.struts2.ServletActionContext;
import org.springframework.http.HttpStatus;

@UnrestrictedAccess
public class ImageCaptchaServlet
extends HttpServlet {
    public static final String CAPTCHA_ID = "id";
    public static final String ACTION = "action";
    public static final String GENERIC_ACTION = "genericAction";
    public static final String CAPTCHA_GENERATION = "captchaGeneration";
    public static final String CAPTCHA_MANAGER = "captchaManager";
    public static final String ACTION_RATE_LIMITER_CAPTCHA_GENERATION = "actionRateLimiterCaptchaGeneration";

    static CaptchaManager getCaptchaManager() {
        return (CaptchaManager)ContainerManager.getComponent((String)CAPTCHA_MANAGER);
    }

    static ActionRateLimiter getActionRateLimiterCaptchaGeneration() {
        return (ActionRateLimiter)ContainerManager.getComponent((String)ACTION_RATE_LIMITER_CAPTCHA_GENERATION);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        byte[] captchaChallengeAsPng;
        String action = httpServletRequest.getParameter(ACTION);
        String rateLimiterKey = this.isValidAction(action) ? action : GENERIC_ACTION;
        String isReqAllowed = ImageCaptchaServlet.getActionRateLimiterCaptchaGeneration().isRequestAllowed(rateLimiterKey, CAPTCHA_GENERATION);
        if (!isReqAllowed.equals("success")) {
            ServletActionContext.getResponse().setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            return;
        }
        String captchaId = httpServletRequest.getParameter(CAPTCHA_ID);
        if (captchaId == null || captchaId.isEmpty()) {
            return;
        }
        try {
            ImageCaptchaService imageCaptchaService = ImageCaptchaServlet.getCaptchaManager().getImageCaptchaService();
            if (imageCaptchaService == null) {
                throw new RuntimeException("There was a problem creating the CAPTCHA service. This probably indicates a problem with Java's image subsystem. You may need to configure your application server to supply the system property java.awt.headless=true.");
            }
            BufferedImage challenge = imageCaptchaService.getImageChallengeForID(captchaId, httpServletRequest.getLocale());
            ByteArrayOutputStream fout = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)challenge, "png", fout);
            captchaChallengeAsPng = fout.toByteArray();
        }
        catch (IllegalArgumentException e) {
            httpServletResponse.sendError(404);
            return;
        }
        catch (CaptchaServiceException e) {
            httpServletResponse.sendError(500);
            return;
        }
        httpServletResponse.setHeader("Cache-Control", "no-store");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setContentType("image/png");
        ServletOutputStream responseOutputStream = httpServletResponse.getOutputStream();
        responseOutputStream.write(captchaChallengeAsPng);
        responseOutputStream.flush();
        responseOutputStream.close();
    }

    private boolean isValidAction(String action) {
        return action != null && !action.isEmpty();
    }
}

