/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.internal.health.analytics.HealthCheckAnalyticsSender;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
@ParametersAreNonnullByDefault
public class JohnsonAnalyticsServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(JohnsonAnalyticsServlet.class);
    @VisibleForTesting
    static final String HEALTH_CHECK_ANALYTICS_SENDER_KEY = "healthCheckAnalyticsSender";
    private static final Collection<RequestHandler> HANDLER_CHAIN = ImmutableList.of((Object)new EventKbArticleClickedHandler(), (Object)new GeneralKbArticleLinkClickedHandler());

    private static HealthCheckAnalyticsSender getHealthCheckAnalyticsSender() {
        return (HealthCheckAnalyticsSender)BootstrapUtils.getBootstrapContext().getBean(HEALTH_CHECK_ANALYTICS_SENDER_KEY, HealthCheckAnalyticsSender.class);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        Optional<RequestHandler> requestHandler = HANDLER_CHAIN.stream().filter(thisHandler -> thisHandler.canHandle(request)).findFirst();
        if (requestHandler.isPresent()) {
            requestHandler.get().handle(request, response);
        } else {
            response.setStatus(404);
        }
    }

    private static interface RequestHandler {
        public boolean canHandle(HttpServletRequest var1);

        public void handle(HttpServletRequest var1, HttpServletResponse var2);
    }

    public static class EventKbArticleClickedHandler
    implements RequestHandler {
        public static final String URL_SUFFIX = "/johnson/analytics/kb/event";

        @Override
        public boolean canHandle(HttpServletRequest request) {
            return request.getRequestURI().endsWith(URL_SUFFIX);
        }

        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response) {
            String eventId = request.getParameter("eventId");
            if (StringUtils.isBlank((CharSequence)eventId)) {
                LOGGER.warn("No event ID was provided");
                response.setStatus(400);
            } else {
                JohnsonAnalyticsServlet.getHealthCheckAnalyticsSender().sendHelpLinkClickedForEvent(eventId);
                response.setStatus(200);
            }
        }
    }

    public static class GeneralKbArticleLinkClickedHandler
    implements RequestHandler {
        public static final String URL_SUFFIX = "/johnson/analytics/kb/general";

        @Override
        public boolean canHandle(HttpServletRequest request) {
            return request.getRequestURI().endsWith(URL_SUFFIX);
        }

        @Override
        public void handle(HttpServletRequest request, HttpServletResponse response) {
            String kbUrl = request.getParameter("kbUrl");
            if (StringUtils.isBlank((CharSequence)kbUrl)) {
                LOGGER.warn("No KB URL was provided");
                response.setStatus(400);
            } else {
                JohnsonAnalyticsServlet.getHealthCheckAnalyticsSender().sendGeneralHelpLinkClicked(kbUrl);
                response.setStatus(200);
            }
        }
    }
}

