/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.impl.health.web.JohnsonPageDataProvider;
import com.atlassian.confluence.json.json.Json;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.plugins.whitelist.InboundWhitelist;
import com.atlassian.spring.container.ComponentNotFoundException;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class JohnsonDataServlet
extends HttpServlet {
    public static final String URL_SUFFIX = "/johnson/data";
    private static final String HTTP_REQUEST_ORIGIN_HEADER = "Origin";
    private static final String HTTP_REQUEST_ORIGIN_HEADER_TEST = "Origin-Test";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    private static final String INBOUND_WHITELIST = "inboundWhitelist";
    private JohnsonPageDataProvider johnsonPageDataProvider;
    private static final Logger LOGGER = LoggerFactory.getLogger(JohnsonDataServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.johnsonPageDataProvider = (JohnsonPageDataProvider)BootstrapUtils.getBootstrapContext().getBean(JohnsonPageDataProvider.class);
    }

    @VisibleForTesting
    void setJohnsonPageDataProvider(JohnsonPageDataProvider johnsonPageDataProvider) {
        this.johnsonPageDataProvider = Objects.requireNonNull(johnsonPageDataProvider);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block8: {
            if (request.getRequestURI().endsWith(URL_SUFFIX)) {
                String origin;
                String string = origin = request.getHeader(HTTP_REQUEST_ORIGIN_HEADER) != null ? request.getHeader(HTTP_REQUEST_ORIGIN_HEADER) : request.getHeader(HTTP_REQUEST_ORIGIN_HEADER_TEST);
                if (origin != null) {
                    try {
                        InboundWhitelist inboundWhitelist = (InboundWhitelist)ContainerManager.getComponent((String)INBOUND_WHITELIST);
                        if (null != inboundWhitelist && inboundWhitelist.isAllowed(URI.create(origin))) {
                            String encodedURL = HtmlUtil.htmlEncode(origin);
                            response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, HtmlUtil.urlDecode(encodedURL));
                            response.setContentType("application/json");
                            Json johnsonPageData = this.johnsonPageDataProvider.getPageData();
                            response.getWriter().write(johnsonPageData.serialize());
                            break block8;
                        }
                        response.setStatus(403);
                        response.getWriter().write("The Origin is not included in the allow list. Please add the url to the allow list to allow access");
                    }
                    catch (ComponentNotFoundException ex) {
                        LOGGER.error("Failed to find component", (Throwable)ex);
                        response.setStatus(500);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Exception occurred while rendering response", (Throwable)ex);
                        response.setStatus(500);
                    }
                } else {
                    response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, HtmlUtil.urlDecode(HtmlUtil.htmlEncode(request.getRequestURL().toString().replace(request.getRequestURI(), ""))));
                    response.setContentType("application/json");
                    Json johnsonPageData = this.johnsonPageDataProvider.getPageData();
                    response.getWriter().write(johnsonPageData.serialize());
                }
            } else {
                response.setStatus(404);
            }
        }
    }
}

