/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.johnson.JohnsonUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.confluence.web.UrlBuilder;
import com.atlassian.johnson.Johnson;
import com.atlassian.spring.container.ContainerManager;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

@UnrestrictedAccess
public class JohnsonDismissEventsServlet
extends HttpServlet {
    public static final String URL_SUFFIX = "/johnson/events/dismiss";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getRequestURI().endsWith(URL_SUFFIX)) {
            if (this.notLoggedIn()) {
                String loginUrl = new UrlBuilder(SeraphUtils.getLoginURL(request)).toString();
                response.sendRedirect(loginUrl);
            } else if (this.canDismissEvents()) {
                JohnsonUtils.dismissEvents();
                response.sendRedirect(request.getContextPath() + "/");
            } else {
                response.sendRedirect(request.getContextPath() + Johnson.getConfig().getErrorPath() + "#no-admin");
            }
        } else {
            response.setStatus(404);
        }
    }

    private PermissionManager getPermissionManager() {
        return (PermissionManager)ContainerManager.getComponent((String)"permissionManager", PermissionManager.class);
    }

    private boolean notLoggedIn() {
        return AuthenticatedUserThreadLocal.get() == null;
    }

    private boolean canDismissEvents() {
        ConfluenceUser requestingUser = AuthenticatedUserThreadLocal.get();
        return this.getPermissionManager().isSystemAdministrator(requestingUser) && JohnsonUtils.allEventsDismissible();
    }
}

