/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

final class ServletExecutionMethodResolver {
    private static final Map<String, String> httpMethodToMethodMapping = Map.of("DELETE", "doDelete", "GET", "doGet", "HEAD", "doHead", "OPTIONS", "doOptions", "POST", "doPost", "PUT", "doPut", "TRACE", "doTrace");

    ServletExecutionMethodResolver() {
    }

    private static Stream<MethodResolver> methodResolvers(Class<?> servletClass, String requestMethodName) {
        return Stream.of(() -> servletClass.getDeclaredMethod(requestMethodName, HttpServletRequest.class, HttpServletResponse.class), () -> servletClass.getDeclaredMethod("service", HttpServletRequest.class, HttpServletResponse.class), () -> servletClass.getMethod("service", ServletRequest.class, ServletResponse.class));
    }

    Optional<Method> getRequestMethod(Class<?> servletClass, HttpServletRequest request) {
        String requestMethodName = httpMethodToMethodMapping.getOrDefault(request.getMethod(), "");
        return ServletExecutionMethodResolver.methodResolvers(servletClass, requestMethodName).flatMap(MethodResolver::stream).findFirst();
    }

    @FunctionalInterface
    static interface MethodResolver {
        public Method findMethod() throws NoSuchMethodException;

        default public Stream<Method> stream() {
            try {
                return Stream.of(this.findMethod());
            }
            catch (NoSuchMethodException e) {
                return Stream.empty();
            }
        }
    }
}

