/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.impl.security.access.AnnotatedPermitChecker;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.security.websudo.WebSudoManager;
import com.atlassian.confluence.servlet.ServletExecutionMethodResolver;
import com.atlassian.http.method.Methods;
import com.atlassian.plugin.servlet.DelegatingPluginServlet;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.util.RequestUtil;
import com.atlassian.sal.api.permission.AuthorisationException;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.spring.container.LazyComponentReference;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class ServletModuleContainerServlet
extends com.atlassian.plugin.servlet.ServletModuleContainerServlet {
    private final Supplier<ServletModuleManager> servletModuleManagerReference;
    private final Supplier<XsrfTokenService> xsrfTokenServiceRef;
    private final Supplier<WebSudoManager> webSudoManagerRef;
    private static final Logger log = LoggerFactory.getLogger(ServletModuleContainerServlet.class);
    private ServletConfig servletConfig;

    public ServletModuleContainerServlet() {
        this((Supplier<ServletModuleManager>)new LazyComponentReference("servletModuleManager"), (Supplier<XsrfTokenService>)new LazyComponentReference("xsrfTokenService"), (Supplier<WebSudoManager>)new LazyComponentReference("webSudoManager"));
    }

    ServletModuleContainerServlet(Supplier<ServletModuleManager> servletModuleManagerReference, Supplier<XsrfTokenService> xsrfTokenServiceRef, Supplier<WebSudoManager> webSudoManagerRef) {
        this.servletModuleManagerReference = servletModuleManagerReference;
        this.xsrfTokenServiceRef = xsrfTokenServiceRef;
        this.webSudoManagerRef = webSudoManagerRef;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletConfig = servletConfig;
    }

    public @Nullable ServletModuleManager getServletModuleManager() {
        return ContainerManager.isContainerSetup() ? this.servletModuleManagerReference.get() : null;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.requestRequiresProtection(request) && !this.validateToken(request)) {
            response.sendError(403, "XSRF check failed");
            return;
        }
        ServletModuleManager servletModuleManager = this.getServletModuleManager();
        if (servletModuleManager == null) {
            super.service(request, response);
            return;
        }
        AnnotatedPermitChecker annotatedPermitChecker = (AnnotatedPermitChecker)request.getAttribute("3af_annotated_permitted_checker");
        HttpServlet servlet = servletModuleManager.getServlet(RequestUtil.getPathInfo((HttpServletRequest)request), this.servletConfig);
        if (servlet != null) {
            Method methodToCheck;
            Class<?> currentServletClass;
            if (servlet instanceof DelegatingPluginServlet) {
                servlet = ((DelegatingPluginServlet)servlet).getModuleDescriptor().getModule();
            }
            if (!annotatedPermitChecker.verifyPermission(currentServletClass = servlet.getClass(), methodToCheck = (Method)new ServletExecutionMethodResolver().getRequestMethod(currentServletClass, request).orElse(null)).permitted()) {
                log.warn("Access check is failed. Skipping Servlet {}", (Object)currentServletClass.getName());
                throw new AuthorisationException();
            }
            WebSudoManager webSudoManager = this.webSudoManagerRef.get();
            if (webSudoManager.matches(request.getServletPath(), currentServletClass, methodToCheck)) {
                if (webSudoManager.canExecuteRequest(request)) {
                    webSudoManager.markWebSudoRequest(request);
                } else {
                    webSudoManager.enforceWebSudoProtection(request, response);
                    return;
                }
            }
        }
        super.service(request, response);
    }

    private boolean requestRequiresProtection(HttpServletRequest request) throws ServletException {
        boolean requestRequiresProtection;
        if (!Methods.isMutative((String)request.getMethod())) {
            return false;
        }
        ServletModuleManager servletModuleManager = this.getServletModuleManager();
        if (servletModuleManager == null) {
            return false;
        }
        HttpServlet servlet = servletModuleManager.getServlet(RequestUtil.getPathInfo((HttpServletRequest)request), this.servletConfig);
        boolean bl = requestRequiresProtection = servlet != null && servlet.getServletConfig() != null && Boolean.parseBoolean(servlet.getInitParameter("RequireSecurityToken"));
        if (ConfluenceSystemProperties.isDevMode() && !requestRequiresProtection) {
            log.warn("Servlet has not opted in for XSRF protection. Please refer https://developer.atlassian.com/server/confluence/enable-xsrf-protection-for-your-app for configuring it.");
        }
        return requestRequiresProtection;
    }

    private boolean validateToken(HttpServletRequest request) {
        return !ContainerManager.isContainerSetup() || this.xsrfTokenServiceRef.get().hasValidToken(request);
    }
}

