/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.impl.security.access.AnnotatedPermitChecker;
import com.atlassian.confluence.servlet.ServletManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.sal.api.permission.AuthorisationException;
import com.atlassian.spring.container.ContainerManager;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;

@UnrestrictedAccess
public class SpringManagedServlet
extends HttpServlet {
    public static final String COMPONENT_NAME_KEY = "springComponentName";
    private static final Logger log = LoggerFactory.getLogger(SpringManagedServlet.class);
    private ServletManager servletManager;
    private ServletConfig servletConfig;
    private String componentName;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletConfig = servletConfig;
        this.componentName = servletConfig.getInitParameter(COMPONENT_NAME_KEY);
        if (!StringUtils.isNotEmpty((CharSequence)this.componentName)) {
            throw new ServletException(this.getServletName() + " missing a springComponentName servlet parameter");
        }
    }

    public void destroy() {
        if (this.servletManager != null) {
            try {
                this.servletManager.servletDestroyed(this);
            }
            catch (Exception e) {
                log.error("Error destroying servlet: {}", (Object)e, (Object)e);
            }
        }
        super.destroy();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletManager servletManager;
        block4: {
            servletManager = this.getServletManager();
            if (servletManager != null) {
                Class<? extends ServletManager> servletManagerClass = SpringManagedServlet.getServletManagerClass(servletManager);
                try {
                    Method serviceMethod = servletManagerClass.getMethod("service", SpringManagedServlet.class, HttpServletRequest.class, HttpServletResponse.class);
                    AnnotatedPermitChecker annotatedPermitChecker = (AnnotatedPermitChecker)request.getAttribute("3af_annotated_permitted_checker");
                    if (!annotatedPermitChecker.verifyPermission(servletManagerClass, serviceMethod).permitted()) {
                        log.warn("ServletManager [{}] does not sacrifice access check for current user", servletManager.getClass());
                        throw new AuthorisationException();
                    }
                    break block4;
                }
                catch (NoSuchMethodException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            throw new ServletException("Confluence is not yet configured to service this request");
        }
        servletManager.service(this, request, response);
    }

    private static Class<? extends ServletManager> getServletManagerClass(ServletManager servletManager) {
        if (AopUtils.isJdkDynamicProxy((Object)servletManager)) {
            Class targetClass = ((Advised)servletManager).getTargetSource().getTargetClass();
            if (targetClass == null) {
                throw new IllegalStateException();
            }
            return targetClass;
        }
        return servletManager.getClass();
    }

    private synchronized @Nullable ServletManager getServletManager() throws ServletException {
        if (this.servletManager == null && GeneralUtil.isSetupComplete()) {
            try {
                this.servletManager = (ServletManager)ContainerManager.getComponent((String)this.componentName);
                if (this.servletManager == null) {
                    log.error("{} unable to load servlet manager. Could not find component with name: {}", (Object)this.getServletName(), (Object)this.componentName);
                } else {
                    this.servletManager.servletInitialised(this, this.servletConfig);
                }
            }
            catch (ClassCastException e) {
                log.error("{} unable to load servlet manager. Component with name {} is wrong class: {}", new Object[]{this.getServletName(), this.componentName, ContainerManager.getComponent((String)this.componentName).getClass().getName()});
            }
        }
        return this.servletManager;
    }
}

