/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.util.GeneralUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class TinyUrlServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(TinyUrlServlet.class);

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (!GeneralUtil.isSetupComplete()) {
            httpServletResponse.sendError(503);
            return;
        }
        String identifier = httpServletRequest.getPathInfo();
        if (identifier == null) {
            identifier = "";
        } else if (identifier.startsWith("/")) {
            identifier = identifier.substring(1);
        }
        String baseUrl = GeneralUtil.getGlobalSettings().getBaseUrl();
        if (baseUrl == null) {
            log.warn("GeneralUtil.getGlobalSettings().getBaseUrl() returned null. Server Base Url should never be null.");
            baseUrl = GeneralUtil.lookupDomainName(httpServletRequest);
        }
        httpServletResponse.sendRedirect(baseUrl + "/pages/tinyurl.action?urlIdentifier=" + identifier);
    }
}

