/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet.download;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadStrategy;
import com.google.common.io.ByteStreams;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class ServeAfterTransactionDownload
implements DownloadStrategy {
    private PlatformTransactionManager transactionManager;
    private static final Logger log = LoggerFactory.getLogger(ServeAfterTransactionDownload.class);

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public static String getDecodedPathInfo(HttpServletRequest httpServletRequest) {
        return HtmlUtil.urlDecode(httpServletRequest.getPathInfo());
    }

    private @Nullable InputStream getStreamInTransaction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        TransactionTemplate tt = new TransactionTemplate(this.transactionManager);
        StreamResult result = (StreamResult)tt.execute(this.getStreamResultCallback(httpServletRequest, httpServletResponse));
        return Objects.requireNonNull(result).getStream();
    }

    public final void serveFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws DownloadException {
        try (InputStream is = this.getStreamInTransaction(httpServletRequest, httpServletResponse);){
            if (is == null) {
                return;
            }
            this.streamResponse(is, (OutputStream)httpServletResponse.getOutputStream());
        }
        catch (IOException e) {
            throw new DownloadException((Exception)e);
        }
        finally {
            this.cleanupTempFile(httpServletRequest);
        }
    }

    void cleanupTempFile(HttpServletRequest httpServletRequest) {
        File tempFile = (File)httpServletRequest.getSession().getAttribute("tempFile");
        if (tempFile != null && tempFile.exists()) {
            ServeAfterTransactionDownload.deleteTempFileFromDir(tempFile.toPath());
        }
    }

    @VisibleForTesting
    static boolean deleteTempFileFromDir(Path tempFilePath) {
        if (tempFilePath == null) {
            return false;
        }
        try {
            Files.delete(tempFilePath);
            return true;
        }
        catch (IOException e) {
            log.error("Error deleting temp file", (Throwable)e);
            return false;
        }
    }

    protected void streamResponse(InputStream fromStream, OutputStream toStream) throws IOException {
        ByteStreams.copy((InputStream)fromStream, (OutputStream)toStream);
        toStream.flush();
    }

    protected TransactionCallback<StreamResult> getStreamResultCallback(HttpServletRequest request, HttpServletResponse response) {
        return new StreamResultCallback(request, response);
    }

    protected abstract @Nullable InputStream getStreamForDownload(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    private static class StreamResult {
        private final IOException exception;
        private final InputStream stream;

        public StreamResult(InputStream stream, IOException exception) {
            this.exception = exception;
            this.stream = stream;
        }

        public @Nullable InputStream getStream() throws IOException {
            if (this.exception != null) {
                throw new IOException("An exception was encountered while getting a stream", this.exception);
            }
            return this.stream;
        }
    }

    protected class StreamResultCallback
    implements TransactionCallback<StreamResult> {
        private final HttpServletRequest request;
        private final HttpServletResponse response;

        public StreamResultCallback(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public StreamResult doInTransaction(@NonNull TransactionStatus transactionStatus) {
            InputStream is = null;
            IOException exception = null;
            try {
                is = ServeAfterTransactionDownload.this.getStreamForDownload(this.request, this.response);
            }
            catch (IOException ex) {
                exception = ex;
            }
            return new StreamResult(is, exception);
        }
    }
}

