/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet.simpledisplay;

import com.atlassian.confluence.dmz.pages.PageManagerInternal;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConverter;
import com.atlassian.confluence.servlet.simpledisplay.PathConverterManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.QueryStringUtil;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractPathConverter
implements PathConverter,
InitializingBean,
DisposableBean {
    protected static final ConvertedPath NO_REDIRECT = new ConvertedPath("");
    protected static final String READABLE_URL_DARK_FEATURE = "confluence.readable.url";
    protected final PathConverterManager pathConverterManager;
    protected final PageManagerInternal pageManager;
    protected final PermissionManager permissionManager;
    protected final DarkFeatureManager darkFeatureManager;

    protected AbstractPathConverter(PathConverterManager pathConverterManager, PageManagerInternal pageManager, PermissionManager permissionManager, DarkFeatureManager darkFeatureManager) {
        this.pathConverterManager = pathConverterManager;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.darkFeatureManager = darkFeatureManager;
    }

    public void destroy() throws Exception {
        this.pathConverterManager.removePathConverter(this);
    }

    protected String toQueryParameters(Map<String, String> queryParams) {
        return queryParams.isEmpty() ? "" : "?" + QueryStringUtil.toString(queryParams, StandardCharsets.UTF_8);
    }

    protected boolean isNotDraft(AbstractPage page) {
        return page != null && !page.isDraft();
    }

    protected boolean currentUserCanEdit(AbstractPage page) {
        return this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.EDIT, page);
    }

    protected boolean isSafeToRedirectAndRevealPageId(AbstractPage page) {
        return !(!this.isNotDraft(page) && !this.currentUserCanEdit(page) || AuthenticatedUserThreadLocal.get() == null && !this.permissionManager.hasPermission(null, Permission.VIEW, page));
    }

    protected boolean hasPagePermission(AbstractPage page) {
        return this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, page);
    }
}

