/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet.simpledisplay;

import com.atlassian.confluence.dmz.pages.PageManagerInternal;
import com.atlassian.confluence.pages.AddressablePage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.servlet.simpledisplay.AbstractPathConverter;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConversionAction;
import com.atlassian.confluence.servlet.simpledisplay.PathConverterManager;
import com.atlassian.confluence.util.QueryStringUtil;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class BlogPathConverter
extends AbstractPathConverter {
    private static final String DISPLAY_BLOG_POST_PATH = "/pages/viewpage.action";
    private static final String DISPLAY_BLOG_DATEVIEW_PATH = "/pages/viewblogposts.action";

    protected BlogPathConverter(PathConverterManager pathConverterManager, PageManagerInternal pageManager, PermissionManager permissionManager, DarkFeatureManager darkFeatureManager) {
        super(pathConverterManager, pageManager, permissionManager, darkFeatureManager);
    }

    public void afterPropertiesSet() throws Exception {
        this.pathConverterManager.addPathConverter(30, this);
    }

    @Override
    public boolean handles(String simplePath) {
        StringTokenizer st = new StringTokenizer(simplePath, "/");
        if (st.countTokens() < 3 || st.countTokens() > 5) {
            return false;
        }
        BlogPathBean bpb = this.getBlogPath(st);
        return this.validatePath(bpb);
    }

    @Override
    public ConvertedPath getPath(String path, String queryString) {
        BlogPathBean bpb = this.getBlogPath(new StringTokenizer(path, "/"));
        Map<String, String> queryParams = QueryStringUtil.toMap(queryString, StandardCharsets.UTF_8);
        if (this.darkFeatureManager.isEnabledForAllUsers("confluence.readable.url").orElse(false).booleanValue()) {
            if (bpb.getDay() > 0) {
                if (!bpb.getTitle().isEmpty()) {
                    Calendar calendar = BlogPost.getCalendarFromDatePath("/" + bpb.getPostingDay());
                    BlogPost blogPost = this.pageManager.getBlogPost(bpb.getSpaceKey(), bpb.getTitle(), calendar);
                    if (blogPost != null && blogPost.isLatestVersion() && this.isSafeToRedirectAndRevealPageId(blogPost)) {
                        boolean shouldDisplayTitle = this.hasPagePermission(blogPost);
                        return new ConvertedPath(AddressablePage.of(blogPost).getUrlPath(shouldDisplayTitle) + this.toQueryParameters(queryParams), PathConversionAction.REDIRECT, false);
                    }
                    return this.redirectToViewPageAction(bpb.getSpaceKey(), bpb.getTitle(), bpb.getPostingDay());
                }
                return new ConvertedPath(bpb.getPathPrefix() + "/" + bpb.getPostingDay() + this.toQueryParameters(queryParams), PathConversionAction.REDIRECT, false);
            }
            return new ConvertedPath(bpb.getPathPrefix() + "/" + bpb.getYear() + "/" + bpb.getMonth() + this.toQueryParameters(queryParams), PathConversionAction.REDIRECT, false);
        }
        String spaceKey = bpb.getSpaceKey();
        String blogTitle = bpb.getTitle();
        if (StringUtils.isNotBlank((CharSequence)blogTitle)) {
            return this.redirectToViewPageAction(spaceKey, blogTitle, bpb.getPostingDay());
        }
        String period = Integer.toString(bpb.getDay() < 0 ? 2 : 5);
        ConvertedPath convertedPath = new ConvertedPath(DISPLAY_BLOG_DATEVIEW_PATH);
        convertedPath.addParameter("key", spaceKey);
        convertedPath.addParameter("postingDate", bpb.getPostingDay());
        convertedPath.addParameter("period", period);
        return convertedPath;
    }

    private ConvertedPath redirectToViewPageAction(String spaceKey, String blogTitle, String postingDay) {
        ConvertedPath convertedPath = new ConvertedPath(DISPLAY_BLOG_POST_PATH);
        convertedPath.addParameter("spaceKey", spaceKey);
        convertedPath.addParameter("title", blogTitle);
        convertedPath.addParameter("postingDay", postingDay);
        return convertedPath;
    }

    private BlogPathBean getBlogPath(StringTokenizer st) {
        String spaceKey = st.nextToken();
        int year = this.getInt(st);
        int month = this.getInt(st);
        int day = -1;
        if (st.hasMoreTokens()) {
            day = this.getInt(st);
        }
        String blogTitle = "";
        if (st.hasMoreTokens()) {
            blogTitle = st.nextToken();
        }
        return new BlogPathBean(spaceKey, year, month, day, blogTitle);
    }

    private boolean validatePath(BlogPathBean bpb) {
        if (bpb.getMonth() < 1 || bpb.getMonth() > 12) {
            return false;
        }
        return bpb.getDay() == -1 || bpb.getDay() >= 0 && bpb.getDay() <= 31;
    }

    private int getInt(StringTokenizer st) {
        try {
            return Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static class BlogPathBean {
        private final String spaceKey;
        private final int year;
        private final int month;
        private final int day;
        private final String title;

        public BlogPathBean(String spaceKey, int year, int month, int day, String title) {
            this.spaceKey = spaceKey;
            this.year = year;
            this.month = month;
            this.day = day;
            this.title = title;
        }

        public String getSpaceKey() {
            return this.spaceKey;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }

        public String getTitle() {
            return this.title;
        }

        public String getPostingDay() {
            return this.year + "/" + this.month + "/" + (this.day > 0 ? this.day : 1);
        }

        public String getPathPrefix() {
            return "/spaces/" + this.spaceKey + "/blog";
        }
    }
}

