/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet.simpledisplay;

import com.atlassian.confluence.dmz.pages.PageManagerInternal;
import com.atlassian.confluence.pages.AddressablePage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.servlet.simpledisplay.AbstractPathConverter;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConversionAction;
import com.atlassian.confluence.servlet.simpledisplay.PathConverterManager;
import com.atlassian.confluence.util.QueryStringUtil;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.StringTokenizer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class PagePathConverter
extends AbstractPathConverter
implements InitializingBean,
DisposableBean {
    private static final String DISPLAY_PAGE_PATH = "/pages/viewpage.action";

    protected PagePathConverter(PathConverterManager pathConverterManager, PageManagerInternal pageManager, PermissionManager permissionManager, DarkFeatureManager darkFeatureManager) {
        super(pathConverterManager, pageManager, permissionManager, darkFeatureManager);
    }

    public void afterPropertiesSet() throws Exception {
        this.pathConverterManager.addPathConverter(10, this);
    }

    @Override
    public boolean handles(String simplePath) {
        return new StringTokenizer(simplePath, "/").countTokens() == 2;
    }

    @Override
    public ConvertedPath getPath(String path, String queryString) {
        StringTokenizer st = new StringTokenizer(path, "/");
        String spaceKey = st.nextToken();
        String pageTitle = st.nextToken();
        if (this.darkFeatureManager.isEnabledForAllUsers("confluence.readable.url").orElse(false).booleanValue()) {
            Page page = this.pageManager.getPage(spaceKey, pageTitle);
            Map<String, String> queryParams = QueryStringUtil.toMap(queryString, StandardCharsets.UTF_8);
            queryParams.remove("pageId");
            if (page != null && page.isLatestVersion() && this.isSafeToRedirectAndRevealPageId(page)) {
                boolean shouldDisplayTitle = this.hasPagePermission(page);
                return new ConvertedPath(AddressablePage.of(page).getUrlPath(shouldDisplayTitle) + this.toQueryParameters(queryParams), PathConversionAction.REDIRECT, false);
            }
            return this.redirectToViewPageAction(spaceKey, pageTitle);
        }
        return this.redirectToViewPageAction(spaceKey, pageTitle);
    }

    private ConvertedPath redirectToViewPageAction(String spaceKey, String pageTitle) {
        ConvertedPath convertedPath = new ConvertedPath(DISPLAY_PAGE_PATH);
        convertedPath.addParameter("spaceKey", spaceKey);
        convertedPath.addParameter("title", pageTitle);
        return convertedPath;
    }
}

