/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.servlet.simpledisplay;

import com.atlassian.confluence.servlet.simpledisplay.AbstractPathConverter;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConversionAction;
import com.atlassian.confluence.servlet.simpledisplay.PathConverterManager;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.QueryStringUtil;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SpacePathConverter
extends AbstractPathConverter {
    public static final String DISPLAY_SPACE_HOME_PAGE_PATH = "/spaces/viewspace.action";

    public SpacePathConverter(PathConverterManager pathConverterManager, DarkFeatureManager darkFeatureManager) {
        super(pathConverterManager, null, null, darkFeatureManager);
    }

    public void afterPropertiesSet() throws Exception {
        this.pathConverterManager.addPathConverter(50, this);
    }

    @Override
    public boolean handles(String simplePath) {
        Pattern pattern = Pattern.compile("^/?\\p{Alnum}*/?$");
        return pattern.matcher(simplePath).matches();
    }

    @Override
    public ConvertedPath getPath(String path, String queryString) {
        String[] parts = HtmlUtil.urlDecode(path, StandardCharsets.UTF_8).split("/");
        Map<String, String> queryParams = QueryStringUtil.toMap(queryString, StandardCharsets.UTF_8);
        String spaceKey = path;
        if (this.darkFeatureManager.isEnabledForAllUsers("confluence.readable.url").orElse(false).booleanValue() && !spaceKey.startsWith("~")) {
            return new ConvertedPath("/spaces/" + HtmlUtil.urlEncode(parts[0], StandardCharsets.UTF_8) + "/overview" + this.toQueryParameters(queryParams), PathConversionAction.REDIRECT, false);
        }
        if (StringUtils.isNotBlank((CharSequence)path) && path.endsWith("/")) {
            spaceKey = path.substring(0, path.length() - 1);
        }
        ConvertedPath convertedPath = new ConvertedPath(DISPLAY_SPACE_HOME_PAGE_PATH);
        convertedPath.addParameter("key", spaceKey);
        return convertedPath;
    }
}

