/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup;

import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.confluence.upgrade.BuildNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildNumberChecker {
    private static final Logger log = LoggerFactory.getLogger(BuildNumberChecker.class);
    static final String ALLOW_DOWNGRADE = "com.atlassian.confluence.allow.downgrade";
    private final boolean clustered;

    public BuildNumberChecker(boolean clustered) {
        this.clustered = clustered;
    }

    public void checkBuildNumbers(BuildNumber homeDirectoryFinalizedBuildNumber, BuildNumber applicationBuildNumber, BuildNumber databaseFinalizedBuildNumber) throws BootstrapException {
        log.debug("Checking Confluence build number [{}] against home directory with finalized build number [{}] against database with finalized build number [{}]", new Object[]{applicationBuildNumber, homeDirectoryFinalizedBuildNumber, databaseFinalizedBuildNumber});
        if (databaseFinalizedBuildNumber != null && !databaseFinalizedBuildNumber.equals((Object)homeDirectoryFinalizedBuildNumber)) {
            if (this.clustered) {
                if (!applicationBuildNumber.equals((Object)databaseFinalizedBuildNumber)) {
                    BuildNumberChecker.databaseBuildMismatchWithApplicationAndHomedirBuildNumbers(applicationBuildNumber, databaseFinalizedBuildNumber, homeDirectoryFinalizedBuildNumber);
                }
            } else {
                BuildNumberChecker.homedirDatabaseBuildNumberMismatch(homeDirectoryFinalizedBuildNumber, databaseFinalizedBuildNumber);
            }
        }
        if (applicationBuildNumber.isLowerThan(homeDirectoryFinalizedBuildNumber)) {
            if (BuildNumberChecker.downgradesPermitted()) {
                BuildNumberChecker.downgradeWarning(homeDirectoryFinalizedBuildNumber, applicationBuildNumber);
                return;
            }
            BuildNumberChecker.downgradeError(homeDirectoryFinalizedBuildNumber, applicationBuildNumber);
        }
    }

    private static void downgradeError(BuildNumber homeDirectoryBuildNumber, BuildNumber applicationBuildNumber) throws BootstrapException {
        throw new BootstrapException("Confluence will not start up because the finalized build number in the home directory [" + String.valueOf(homeDirectoryBuildNumber) + "] is newer than the Confluence build number [" + String.valueOf(applicationBuildNumber) + "].");
    }

    private static void downgradeWarning(BuildNumber homeDirectoryBuildNumber, BuildNumber applicationBuildNumber) {
        log.warn("Confluence (with build number {} is starting up against the home directory of a newer version (build number {}). Atlassian does not support running Confluence against a newer home directory.", (Object)applicationBuildNumber, (Object)homeDirectoryBuildNumber);
    }

    private static boolean downgradesPermitted() {
        return Boolean.getBoolean(ALLOW_DOWNGRADE);
    }

    private static void homedirDatabaseBuildNumberMismatch(BuildNumber homeDirectoryBuildNumber, BuildNumber databaseBuildNumber) throws BootstrapException {
        throw new BootstrapException("Confluence will not start up because the build number in the home directory [" + String.valueOf(homeDirectoryBuildNumber) + "] doesn't match the build number in the database [" + String.valueOf(databaseBuildNumber) + "].");
    }

    private static void databaseBuildMismatchWithApplicationAndHomedirBuildNumbers(BuildNumber applicationBuildNumber, BuildNumber databaseFinalizedBuildNumber, BuildNumber homeDirectoryBuildNumber) throws BootstrapException {
        throw new BootstrapException("Confluence cluster node will not start up because the finalized build number in the database [" + String.valueOf(databaseFinalizedBuildNumber) + "] doesn't match either the application build number [" + String.valueOf(applicationBuildNumber) + "] or the home directory build number [" + String.valueOf(homeDirectoryBuildNumber) + "].");
    }
}

