/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.confluence.web.filter.AbstractStaticResourceAwareFilter;
import com.atlassian.core.filters.encoding.FixedHtmlEncodingResponseWrapper;
import com.atlassian.johnson.Johnson;
import com.atlassian.spring.container.ContainerManager;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

@UnrestrictedAccess
public final class ConfluenceEncodingFilter
extends AbstractStaticResourceAwareFilter {
    private final Supplier<SettingsManager> settingsManagerRef = MemoizingComponentReference.containerComponent("settingsManager");

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        request.setCharacterEncoding(this.getEncodingInternal());
        response.setContentType("text/html; charset=" + this.getEncodingInternal());
        filterChain.doFilter((ServletRequest)request, (ServletResponse)new FixedHtmlEncodingResponseWrapper(response));
    }

    private String getEncodingInternal() {
        if (!GeneralUtil.isSetupComplete() || !ContainerManager.isContainerSetup() || Johnson.getEventContainer().hasEvents()) {
            return "UTF-8";
        }
        return this.getGlobalDefaultEncoding();
    }

    private @NonNull String getGlobalDefaultEncoding() {
        return Optional.ofNullable(this.settingsManagerRef.get()).map(SettingsManager::getGlobalSettings).map(Settings::getDefaultEncoding).filter(StringUtils::isNotBlank).orElse("UTF-8");
    }
}

