/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.setup.SetupAppConfig;
import com.atlassian.plugin.PluginSystemLifecycle;
import jakarta.servlet.ServletContext;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class SetupContext {
    private static AnnotationConfigWebApplicationContext context;
    private static final AtomicBoolean initializationDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(ServletContext servletContext) {
        Class<SetupContext> clazz = SetupContext.class;
        synchronized (SetupContext.class) {
            if (SetupContext.isAvailable() || SetupContext.isInitializationDisabled()) {
                throw new IllegalStateException("Setup context has already been initialised");
            }
            context = new AnnotationConfigWebApplicationContext();
            context.setServletContext(servletContext);
            context.setParent(BootstrapUtils.getBootstrapContext());
            context.register(new Class[]{SetupAppConfig.class});
            context.setAllowBeanDefinitionOverriding(false);
            context.refresh();
            ((PluginSystemLifecycle)context.getBean("pluginController", PluginSystemLifecycle.class)).init();
            SetupContext.disableInitialization();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isAvailable() {
        return context != null;
    }

    public static ConfigurableApplicationContext get() {
        return context;
    }

    public static void destroy() {
        if (context != null) {
            context.close();
        }
        context = null;
    }

    public static boolean isInitializationDisabled() {
        return initializationDisabled.get();
    }

    public static void disableInitialization() {
        initializationDisabled.set(true);
    }

    static {
        initializationDisabled = new AtomicBoolean(false);
    }
}

