/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.internal.health.JohnsonEventLevel;
import com.atlassian.confluence.internal.health.JohnsonEventType;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.license.exception.LicenseException;
import com.atlassian.confluence.setup.johnson.JohnsonUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.MemoizingComponentReference;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidLicenseContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(ValidLicenseContextListener.class);
    private final BooleanSupplier isReadyToServe;
    private final Supplier<LicenseService> licenseService;

    public ValidLicenseContextListener() {
        this(GeneralUtil::isReadyToServe, MemoizingComponentReference.containerComponent("licenseService"));
    }

    @VisibleForTesting
    ValidLicenseContextListener(BooleanSupplier isReadyToServe, Supplier<LicenseService> licenseService) {
        this.isReadyToServe = isReadyToServe;
        this.licenseService = licenseService;
    }

    public void contextInitialized(ServletContextEvent event) {
        log.debug("ValidLicenseContextListener contextInitialized called");
        if (this.isReadyToServe.getAsBoolean()) {
            try {
                this.licenseService.get().retrieve();
            }
            catch (LicenseException e) {
                log.error("No valid license found.");
                JohnsonUtils.raiseJohnsonEventRequiringTranslation((JohnsonEventType)JohnsonEventType.LICENSE_INCONSISTENCY, (String)"license.invalid.error", null, (JohnsonEventLevel)JohnsonEventLevel.ERROR);
            }
        }
        log.debug("ValidLicenseContextListener contextInitialized completed successfully");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

