/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.impl.setup.BootstrapConfigurer;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.languages.LocaleParser;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.license.exception.LicenseException;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.SetupContext;
import com.atlassian.confluence.setup.actions.ConfluenceSetupPersister;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugin.SplitStartupPluginSystemLifecycle;
import com.atlassian.sal.spi.HostContextAccessor;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.struts2.ServletActionContext;
import org.springframework.context.ApplicationContext;

public abstract class AbstractSetupAction
extends ConfluenceActionSupport {
    protected static final String SETUP_QUICK = "quick-setup";
    protected static final String SETUP_CLUSTER = "cluster-setup";
    protected static final String SETUP_CUSTOM = "custom-setup";
    protected static final String SETUP_USER_INTERNAL = "internal-user";
    protected static final String SETUP_DB_DATASOURCE = "setupdatasource";
    protected static final String SETUP_DB_CONN_TYPE = "setupdb";
    protected static final String SETUP_DB_CLUSTER_CONN_TYPE = "setupdbcluster";
    protected static final String SETUP_CONTENT_BLANK = "blank";
    protected static final String SETUP_CONTENT_DEMO = "demo";
    protected static final String SETUP_CONTENT_IMPORT = "import";
    protected static final String SETUP_SESSION_ID_KEY = "setup-session-id";
    protected static final String SETUP_SKIP_TO_NEXT_STEP = "skipToNextStep";
    protected static final String SETUP_SKIP_TO_NEXT_STEP_CLUSTER = "skipToNextStepCluster";
    private BootstrapConfigurer bootstrapConfigurer;
    private ConfluenceSetupPersister setupPersister;
    private ContainerManager containerManager;
    private LicenseService licenseService;
    protected ConfluenceSidManager bootstrapSidManager;
    private XsrfTokenGenerator xsrfTokenGenerator;

    protected BootstrapManager getBootstrapManager() {
        return (BootstrapManager)BootstrapUtils.getBootstrapManager();
    }

    public void setBootstrapConfigurer(BootstrapConfigurer bootstrapConfigurer) {
        this.bootstrapConfigurer = bootstrapConfigurer;
    }

    protected BootstrapConfigurer bootstrapConfigurer() {
        return Objects.requireNonNullElseGet(this.bootstrapConfigurer, BootstrapConfigurer::getBootstrapConfigurer);
    }

    @VisibleForTesting
    void setSetupPersister(ConfluenceSetupPersister setupPersister) {
        this.setupPersister = setupPersister;
    }

    protected ConfluenceSetupPersister getSetupPersister() {
        return Objects.requireNonNullElseGet(this.setupPersister, () -> (ConfluenceSetupPersister)this.bootstrapConfigurer().getSetupPersister());
    }

    @Override
    public boolean isPermitted() {
        return !GeneralUtil.isSetupComplete();
    }

    @Override
    public Locale getLocale() {
        ApplicationConfiguration applicationConfig;
        String localeString;
        ApplicationContext bootstrapContext = BootstrapUtils.getBootstrapContext();
        if (bootstrapContext != null && (localeString = (String)(applicationConfig = (ApplicationConfiguration)bootstrapContext.getBean("applicationConfig")).getProperty((Object)"confluence.setup.locale")) != null) {
            return LocaleParser.toLocale(localeString);
        }
        return LocaleManager.DEFAULT_LOCALE;
    }

    protected void performEarlyStartup() {
        ContainerContext containerContext = this.getContainerManager().getContainerContext();
        containerContext.refresh();
        SetupContext.destroy();
        this.getSingletonFromMainContext(SplitStartupPluginSystemLifecycle.class).earlyStartup();
    }

    protected void performLateStartup() {
        this.getSingletonFromMainContext(SplitStartupPluginSystemLifecycle.class).lateStartup();
    }

    private <T> T getSingletonFromMainContext(Class<T> type) {
        ContainerContext containerContext = this.getContainerManager().getContainerContext();
        if (containerContext == null) {
            throw new RuntimeException("illegal access, main context is not (yet) initialised");
        }
        HostContextAccessor hostContextAccessor = (HostContextAccessor)containerContext.getComponent((Object)"hostContextAccessor");
        if (hostContextAccessor == null) {
            throw new RuntimeException("no bean with id \"hostContextAccessor\" in main context");
        }
        Map componentsOfType = hostContextAccessor.getComponentsOfType(type);
        if (componentsOfType.isEmpty()) {
            throw new RuntimeException(String.format("no bean of type \"%s\" in main context", type));
        }
        if (componentsOfType.size() > 1) {
            throw new RuntimeException(String.format("multiple beans of type \"%s\" in main context", type));
        }
        return (T)componentsOfType.values().iterator().next();
    }

    private ContainerManager getContainerManager() {
        return this.containerManager == null ? ContainerManager.getInstance() : this.containerManager;
    }

    @VisibleForTesting
    void setContainerManager(ContainerManager containerManager) {
        this.containerManager = containerManager;
    }

    public String getSetupSessionId() {
        String sessionId = (String)ServletActionContext.getRequest().getSession().getAttribute(SETUP_SESSION_ID_KEY);
        if (sessionId == null) {
            sessionId = UUID.randomUUID().toString();
            ServletActionContext.getRequest().getSession().setAttribute(SETUP_SESSION_ID_KEY, (Object)sessionId);
        }
        return sessionId;
    }

    public void setBootstrapSidManager(ConfluenceSidManager bootstrapSidManager) {
        this.bootstrapSidManager = bootstrapSidManager;
    }

    public XsrfTokenGenerator getXsrfTokenGenerator() {
        return this.xsrfTokenGenerator;
    }

    public void setXsrfTokenGenerator(XsrfTokenGenerator xsrfTokenGenerator) {
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    public String getServerId() {
        if (this.bootstrapSidManager == null) {
            return null;
        }
        try {
            return this.bootstrapSidManager.getSid();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public String getSupportEntitlementNumber() {
        ConfluenceLicense confluenceLicense;
        if (this.licenseService == null) {
            return null;
        }
        try {
            confluenceLicense = this.licenseService.retrieve();
        }
        catch (LicenseException e) {
            return null;
        }
        return confluenceLicense.getSupportEntitlementNumber();
    }

    public String getCurrentSetupStep() {
        return this.getSetupPersister().getCurrentStep();
    }
}

