/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.confluence.api.model.backuprestore.JobOperation;
import com.atlassian.confluence.api.model.backuprestore.JobScope;
import com.atlassian.confluence.api.model.backuprestore.JobState;
import com.atlassian.confluence.backuprestore.BackupRestoreJob;
import com.atlassian.confluence.backuprestore.BackupRestoreSettings;
import com.atlassian.confluence.backuprestore.exception.BackupRestoreException;
import com.atlassian.confluence.impl.backuprestore.IndependentBackupRestoreJobManager;
import com.atlassian.confluence.impl.backuprestore.restore.SpaceRestoreService;
import io.atlassian.util.concurrent.ThreadFactories;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreDemoSpaceHelper {
    private static final Logger log = LoggerFactory.getLogger(RestoreDemoSpaceHelper.class);
    static final String DEMO_CONTENT_ZIP_FILE = "demo-space-8.9.0.zip";
    private final SpaceRestoreService spaceRestoreService;
    final ExecutorService executorService = Executors.newCachedThreadPool(ThreadFactories.namedThreadFactory((String)"demo-space-restore"));
    private final IndependentBackupRestoreJobManager independentBackupRestoreJobManager;

    public RestoreDemoSpaceHelper(IndependentBackupRestoreJobManager independentBackupRestoreJobManager, SpaceRestoreService spaceRestoreService) {
        this.independentBackupRestoreJobManager = independentBackupRestoreJobManager;
        this.spaceRestoreService = spaceRestoreService;
    }

    void restoreDemoBackup(ServletContext servletContext) throws InterruptedException, BackupRestoreException, ExecutionException, URISyntaxException {
        URL demoSpaceZipUrl = this.getDemoSpaceUrl(servletContext);
        log.debug("demo space zip url: {}", (Object)demoSpaceZipUrl);
        File file = new File(demoSpaceZipUrl.toURI());
        if (!file.exists()) {
            throw new IllegalArgumentException("Unable to get file name for the demo space url. Path: " + String.valueOf(demoSpaceZipUrl.toURI()));
        }
        String fileFolder = file.getParent();
        BackupRestoreSettings settings = new BackupRestoreSettings.Builder(JobOperation.RESTORE, JobScope.SPACE).setFilename(file.getName()).setWorkingDir(fileFolder).build();
        log.debug("job setting for demo space restoration: {}", (Object)settings);
        BackupRestoreJob job = this.independentBackupRestoreJobManager.createAndSaveNewJob(this.executorService, JobOperation.RESTORE, JobScope.SPACE, JobState.QUEUED, Instant.now(), "instance_setup", settings);
        this.independentBackupRestoreJobManager.createAndSaveNewJobSettingsRecord(this.executorService, job.getId(), settings);
        this.executorService.submit(() -> {
            try {
                this.spaceRestoreService.doRestoreSynchronously(job, settings);
            }
            catch (BackupRestoreException e) {
                throw new IllegalStateException("Unable to restore demo space backup", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Unable to restore demo space backup", e);
            }
        }).get();
        this.updateJobState(job.getId());
    }

    private void updateJobState(long jobId) throws BackupRestoreException {
        this.independentBackupRestoreJobManager.updateJobStateAfterCompletion(jobId, JobState.FINISHED, null, Instant.now(), this.executorService);
    }

    URL getDemoSpaceUrl(ServletContext servletContext) {
        String path = "/WEB-INF/classes/com/atlassian/confluence/setup/demo-space-8.9.0.zip";
        try {
            return servletContext.getResource("/WEB-INF/classes/com/atlassian/confluence/setup/demo-space-8.9.0.zip");
        }
        catch (MalformedURLException e) {
            log.error("Demo space URL is invalid; using default. URL was [{}]", (Object)"/WEB-INF/classes/com/atlassian/confluence/setup/demo-space-8.9.0.zip");
            return null;
        }
    }
}

