/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.confluence.internal.health.JohnsonEventPredicates;
import com.atlassian.confluence.internal.health.JohnsonEventType;
import com.atlassian.confluence.setup.actions.AbstractSetupAction;
import com.atlassian.confluence.setup.johnson.JohnsonUtils;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.function.Predicate;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectSetupStepAction
extends AbstractSetupAction {
    private static final Logger log = LoggerFactory.getLogger(SelectSetupStepAction.class);
    public static final String RESULT_PRECONDITIONS_FAILED = "checklist";
    private String currentSetupActionName;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        if (JohnsonUtils.eventExists((Predicate)JohnsonEventPredicates.hasType((JohnsonEventType)JohnsonEventType.SETUP))) {
            return RESULT_PRECONDITIONS_FAILED;
        }
        String currentStep = this.getSetupPersister().getCurrentStep();
        this.currentSetupActionName = "complete".equals(currentStep) ? "/setup/finishsetup.action" : "/setup/" + currentStep + ".action";
        log.debug("current setup step is {}", (Object)this.currentSetupActionName);
        return "success";
    }

    public String getCurrentStep() {
        return this.currentSetupActionName;
    }

    public String getServerName() {
        return ServletActionContext.getServletContext().getServerInfo();
    }

    @Override
    public boolean isPermitted() {
        return true;
    }
}

