/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.confluence.setup.ConfluenceDatabaseDetails;
import com.atlassian.confluence.setup.ConfluenceDatabaseDetailsBuilder;
import com.atlassian.confluence.setup.actions.AbstractDatabaseCreationAction;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.struts.xsrf.XsrfProtectionRequired;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
@SystemAdminOnly
public class SetupDatasourceAction
extends AbstractDatabaseCreationAction {
    private static final Logger log = LoggerFactory.getLogger(SetupDatasourceAction.class);
    private String datasourceName = "";
    private boolean multipleDatasources;
    private String dialect;
    private boolean forceOverwriteExistingData = false;

    public String getDatasourceName() {
        return this.datasourceName;
    }

    @StrutsParameter
    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    public boolean isMultipleDatasources() {
        return this.multipleDatasources;
    }

    public String getDialect() {
        return this.dialect;
    }

    @StrutsParameter
    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    @Override
    public String doDefault() throws Exception {
        this.detectDatasource();
        this.dbDetails = new ConfluenceDatabaseDetailsBuilder().databaseType(this.getDatabase()).build();
        this.datasourceName = "java:comp/env/jdbc/" + this.datasourceName;
        return "input";
    }

    @Override
    @XsrfProtectionRequired
    public String execute() throws ConfigurationException {
        return super.execute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    String setupDatabase() throws ConfigurationException {
        try (Connection connection = this.bootstrapConfigurer().getTestDatasourceConnection(this.datasourceName);){
            if (!this.forceOverwriteExistingData && this.getBootstrapStatusProvider().databaseContainsExistingData(connection)) {
                this.addActionError(this.getText("setup.database.tables.exist"));
                String string = "data-exists";
                return string;
            }
            this.dbDetails = this.setupDBDetails(connection);
        }
        catch (Exception e) {
            this.addActionError(this.getText("could.not.lookup.datasource") + ": " + HtmlUtil.htmlEncode(String.valueOf(e)));
            log.warn("Unable to look up datasource: {}", (Object)e.getMessage(), (Object)e);
            return "error";
        }
        try {
            this.getBootstrapManager().bootstrapDatasource(this.datasourceName, this.dbDetails.getDialect());
            return "success";
        }
        catch (Exception e) {
            this.addActionError(this.getText("configuring.db.failed"));
            this.addActionError(e.getMessage());
            log.error("Unable to bootstrap datasource: {}", (Object)e.getMessage(), (Object)e);
            return "error";
        }
    }

    @StrutsParameter
    public void setForceOverwriteExistingData(boolean forceOverwriteExistingData) {
        this.forceOverwriteExistingData = forceOverwriteExistingData;
    }

    private ConfluenceDatabaseDetails setupDBDetails(Connection connection) throws SQLException, ConfigurationException {
        String dbType = this.detectDatabaseType(connection);
        ConfluenceDatabaseDetails dbDetails = new ConfluenceDatabaseDetailsBuilder().databaseType(dbType).build(DatabaseDetails.getDefaults((String)dbType));
        dbDetails.setupForDatabase(dbType);
        if (dbDetails.getDialect() == null) {
            StandardDialectResolver resolver = new StandardDialectResolver();
            Dialect dialect = resolver.resolveDialect((DialectResolutionInfo)new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData()));
            dbDetails.setDialect(dialect.getClass().getName());
        }
        return dbDetails;
    }

    protected void detectDatasource() {
        List<String> datasources = this.findDatasourceNames();
        if (datasources.size() == 1) {
            this.datasourceName = datasources.get(0);
        } else if (datasources.size() > 1) {
            this.multipleDatasources = true;
        }
    }
}

