/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.confluence.setup.actions.AbstractSetupDatabaseAction;
import com.atlassian.confluence.setup.settings.DatabaseTestResult;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.gson.Gson;
import java.sql.Connection;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
@SystemAdminOnly
public class SetupDatasourceTestConnectionAction
extends AbstractSetupDatabaseAction {
    private static final Logger log = LoggerFactory.getLogger(SetupDatasourceTestConnectionAction.class);
    private String datasourceName = "java:comp/env/jdbc/";
    private DatabaseTestResult testResult;
    private Gson gson = new Gson();

    public String getDatasourceName() {
        return this.datasourceName;
    }

    @StrutsParameter
    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    public String execute() throws Exception {
        String databaseType = "other";
        try (Connection connection = this.bootstrapConfigurer().getTestDatasourceConnection(this.datasourceName);){
            databaseType = this.detectDatabaseType(connection);
            this.testResult = this.testConnection(databaseType, connection);
        }
        catch (BootstrapException e) {
            log.warn("Failed when testing the datasource connection with error message: {}", (Object)e.getMessage(), (Object)e);
            this.testResult = this.convertBootstrapException(databaseType, e);
        }
        return "json";
    }

    public String getJSONString() {
        return this.gson.toJson((Object)this.testResult);
    }
}

