/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.backuprestore.exception.BackupRestoreException;
import com.atlassian.confluence.impl.backuprestore.IndependentBackupRestoreJobManager;
import com.atlassian.confluence.impl.backuprestore.restore.SpaceRestoreService;
import com.atlassian.confluence.setup.actions.AbstractSetupAction;
import com.atlassian.confluence.setup.actions.RestoreDemoSpaceHelper;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import jakarta.servlet.ServletContext;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
@SystemAdminOnly
public class SetupDemoContentAction
extends AbstractSetupAction {
    private static final long serialVersionUID = -6285977741051795086L;
    private static final Logger log = LoggerFactory.getLogger(SetupDemoContentAction.class);
    private transient IndependentBackupRestoreJobManager independentBackupRestoreJobManager;
    private transient SpaceRestoreService spaceRestoreService;
    private transient RestoreDemoSpaceHelper restoreDemoSpaceHelper;

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    @XsrfProtectionExcluded
    public String execute() {
        RestoreDemoSpaceHelper restoreHelper = new RestoreDemoSpaceHelper(this.independentBackupRestoreJobManager, this.spaceRestoreService);
        ServletContext servletContext = this.getActiveRequest().getSession().getServletContext();
        URL demoSiteZipUrl = restoreHelper.getDemoSpaceUrl(servletContext);
        if (demoSiteZipUrl == null) {
            log.error("Could not find the demo space on the classpath.");
            this.addActionError("error.could.not.find", "demo-space-8.9.0.zip");
            return "error";
        }
        if (this.independentBackupRestoreJobManager == null) {
            this.independentBackupRestoreJobManager = (IndependentBackupRestoreJobManager)ContainerManager.getComponent((String)"independentBackupRestoreJobManager");
        }
        if (this.spaceRestoreService == null) {
            this.spaceRestoreService = (SpaceRestoreService)ContainerManager.getComponent((String)"spaceRestoreService");
        }
        try {
            if (this.restoreDemoSpaceHelper == null) {
                this.restoreDemoSpaceHelper = new RestoreDemoSpaceHelper(this.independentBackupRestoreJobManager, this.spaceRestoreService);
            }
            this.restoreDemoSpaceHelper.restoreDemoBackup(servletContext);
            this.getSetupPersister().setDemonstrationContentInstalled();
        }
        catch (BackupRestoreException e) {
            log.error("Could not import demo-space-8.9.0.zip: ", (Throwable)e);
            this.addActionError("Could not import demo-space-8.9.0.zip: " + String.valueOf(e));
            return "error";
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return "error";
        }
        catch (Exception e) {
            log.error("demo site import failed ", (Throwable)e);
            this.addActionError("error.failure.loading.demo.content", e);
            return "error";
        }
        this.getSetupPersister().progessSetupStep();
        if (this.getActionErrors().isEmpty()) {
            return "success";
        }
        return "error";
    }

    public void setIndependentBackupRestoreJobManager(IndependentBackupRestoreJobManager independentBackupRestoreJobManager) {
        this.independentBackupRestoreJobManager = independentBackupRestoreJobManager;
    }

    public void setSpaceRestoreService(SpaceRestoreService spaceRestoreService) {
        this.spaceRestoreService = spaceRestoreService;
    }

    @VisibleForTesting
    public void setRestoreDemoSpaceHelper(RestoreDemoSpaceHelper restoreDemoSpaceHelper) {
        this.restoreDemoSpaceHelper = restoreDemoSpaceHelper;
    }
}

