/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.db.DatabaseDetails;
import com.atlassian.confluence.setup.actions.AbstractSetupDatabaseAction;
import com.atlassian.confluence.setup.settings.DatabaseTestResult;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.gson.Gson;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
@SystemAdminOnly
public class SetupStandardDatabaseTestConnectionAction
extends AbstractSetupDatabaseAction {
    private static final Logger log = LoggerFactory.getLogger(SetupStandardDatabaseTestConnectionAction.class);
    private DatabaseTestResult testResult;
    private final Gson gson = new Gson();

    public String execute() throws Exception {
        String databaseType = this.dbDetails.getDatabaseType();
        this.dbDetails.setupForDatabase(databaseType);
        try (Connection connection = this.getBootstrapManager().getTestDatabaseConnection((DatabaseDetails)this.dbDetails);){
            this.testResult = this.testConnection(databaseType, connection);
        }
        catch (BootstrapException e) {
            log.warn("Failed when testing the JDBC connection with error message: {}", (Object)e.getMessage(), (Object)e);
            this.testResult = this.convertBootstrapException(databaseType, e);
        }
        return "json";
    }

    public String getJSONString() {
        return this.gson.toJson((Object)this.testResult);
    }
}

