/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.actions;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.pages.actions.beans.BootstrapAware;
import com.atlassian.confluence.setup.BuildInformation;
import com.atlassian.confluence.setup.SetupContext;
import com.atlassian.confluence.setup.actions.AbstractSetupAction;
import com.atlassian.confluence.setup.actions.ConfluenceSetupPersister;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.db.DatabaseUtils;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.struts.xsrf.XsrfProtectionRequired;
import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
@SystemAdminOnly
public class SetupStartAction
extends AbstractSetupAction
implements BootstrapAware {
    private static final Logger log = LoggerFactory.getLogger(SetupStartAction.class);
    public static final String CLUSTER_UPGRADE = "standalone-to-cluster";
    public static final String CLUSTER_DOWNGRADE = "cluster-to-standalone";
    private static final String EVAL_LICENSE = "evallicense";
    private String setupType;
    private ApplicationProperties applicationProperties;
    @Deprecated
    private ClusterManager clusterManager;
    private FilesystemPath confluenceHome;
    private FilesystemPath localHome;

    @Override
    public String doDefault() throws Exception {
        if (this.isAWSSetup()) {
            return "skipToNextStep";
        }
        if (this.isStandaloneToCluster() && !this.isDatabaseExternal()) {
            this.getSetupPersister().setMigrationCancelled();
            this.getMessageHolder().addActionWarning("setup.start.cluster.upgrade.cannot.start.embedded.db", this.embeddedDatabaseName());
        } else if (this.isStandaloneToCluster()) {
            this.bootstrapConfigurer().setBuildNumber(GeneralUtil.getBuildNumber());
            this.bootstrapConfigurer().save();
            ConfluenceSetupPersister setupPersister = this.getSetupPersister();
            setupPersister.setSetupType("standalone.to.cluster");
            setupPersister.progessSetupStep();
            return "skipToNextStepCluster";
        }
        if (!this.isBuildNumberCorrect()) {
            this.getSetupPersister().setMigrationCancelled();
            this.getMessageHolder().addActionWarning("setup.start.cluster.upgrade.cannot.start.version", "Confluence");
        }
        return "input";
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    @XsrfProtectionRequired
    public String execute() throws Exception {
        this.bootstrapConfigurer().setBuildNumber(GeneralUtil.getBuildNumber());
        this.bootstrapConfigurer().save();
        if (!this.setupConfluenceHome()) {
            return "error";
        }
        ConfluenceSetupPersister setupPersister = this.getSetupPersister();
        setupPersister.setSetupType(this.setupType);
        if (setupPersister.getCurrentStep().equals("setupstart")) {
            setupPersister.progessSetupStep();
        }
        switch (this.setupType) {
            case "custom": 
            case "cluster": {
                return "custom-setup";
            }
            case "install": {
                return EVAL_LICENSE;
            }
            case "standalone.to.cluster": {
                return CLUSTER_UPGRADE;
            }
            case "cluster.to.standalone": {
                this.getSetupPersister().removeClusterSetupEntries();
                this.performEarlyStartup();
                this.bootstrapConfigurer().setProperty("hibernate.setup", (Object)"true");
                this.performLateStartup();
                return CLUSTER_DOWNGRADE;
            }
        }
        throw new RuntimeException("unexpected setup type " + this.setupType);
    }

    private boolean setupConfluenceHome() {
        String localHomeDir = "${localHome}" + System.getProperty("file.separator");
        String confluenceLuceneIndexDir = localHomeDir + "index";
        String confluenceTempDir = localHomeDir + "temp";
        this.setupDirectory(confluenceLuceneIndexDir, "luceneIndexDir", "creating.lucene.index.dir.failed");
        this.setupDirectory(confluenceTempDir, "tempDir", "creating.temp.dir.failed");
        try {
            this.bootstrapConfigurer().setProperty("lucene.index.dir", (Object)confluenceLuceneIndexDir);
            this.bootstrapConfigurer().setProperty("struts.multipart.saveDir", (Object)confluenceTempDir);
            return true;
        }
        catch (Exception e) {
            log.error("Unable to setup Confluence home", (Throwable)e);
            this.addActionError(this.getText("error.recording.default.paths.to.system"));
            return false;
        }
    }

    private File setupDirectory(String dirName, String fieldName, String failureMessageKey) {
        File localHome;
        if (dirName == null || dirName.trim().equals("")) {
            return null;
        }
        File home = this.getConfluenceHome();
        File dir = new File(GeneralUtil.replaceConfluenceConstants(dirName, home, localHome = this.localHome.asJavaPath().toFile()));
        if (!dir.isDirectory() && !dir.mkdirs()) {
            this.addFieldError(fieldName, this.getText(failureMessageKey));
            return null;
        }
        return dir;
    }

    private File getConfluenceHome() {
        if (this.confluenceHome != null) {
            return this.confluenceHome.asJavaFile();
        }
        return new File(this.applicationProperties.getHomeDirectory().getPath());
    }

    @Override
    public void bootstrap() {
        Preconditions.checkState((boolean)SetupContext.isAvailable(), (Object)"Setup context is not available");
        try {
            if (!this.bootstrapSidManager.isSidSet()) {
                this.bootstrapSidManager.initSid();
            }
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Could not initialize SID", e);
        }
    }

    public boolean isAWSSetup() {
        String currentSetupType = this.getSetupPersister().getSetupType();
        return this.isFromScratch() && !"initial".equals(currentSetupType);
    }

    public boolean isStandaloneToCluster() {
        return "standalone.to.cluster".equals(this.getSetupPersister().getSetupType());
    }

    public boolean isClusterToStandalone() {
        return "cluster.to.standalone".equals(this.getSetupPersister().getSetupType());
    }

    public boolean isFromScratch() {
        return !this.isClusterToStandalone() && !this.isStandaloneToCluster();
    }

    public boolean isDatabaseExternal() {
        return DatabaseUtils.evaluationDatabaseName().isEmpty();
    }

    public String embeddedDatabaseName() {
        return DatabaseUtils.evaluationDatabaseName().get();
    }

    public boolean isBuildNumberCorrect() {
        String configBuildNumber = this.getBootstrapStatusProvider().getApplicationConfig().getBuildNumber();
        return configBuildNumber.equals("0") || configBuildNumber.equals(BuildInformation.INSTANCE.getBuildNumber());
    }

    @StrutsParameter
    public void setSetupType(String setupType) {
        this.setupType = setupType;
    }

    public void setConfluenceHome(FilesystemPath confluenceHome) {
        this.confluenceHome = confluenceHome;
    }

    public void setLocalHome(FilesystemPath localHome) {
        this.localHome = localHome;
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }
}

