/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.settings;

import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DarkFeatures {
    private final Set<String> systemEnabledFeatures;
    private final Set<String> siteEnabledFeatures;

    public DarkFeatures(Set<String> systemEnabledFeatures, Set<String> siteEnabledFeatures) {
        this.systemEnabledFeatures = ImmutableSet.copyOf(systemEnabledFeatures);
        this.siteEnabledFeatures = ImmutableSet.copyOf(siteEnabledFeatures);
    }

    public Set<String> getSystemEnabledFeatures() {
        return this.systemEnabledFeatures;
    }

    public Set<String> getSiteEnabledFeatures() {
        return this.siteEnabledFeatures;
    }

    public Set<String> getGlobalEnabledFeatures() {
        return Sets.union(this.systemEnabledFeatures, this.siteEnabledFeatures);
    }

    public Set<String> getAllEnabledFeatures() {
        return Sets.union(this.siteEnabledFeatures, this.systemEnabledFeatures);
    }

    public String getAllEnabledFeaturesAsString() {
        return StringUtils.join(this.getAllEnabledFeatures(), (String)",");
    }

    public boolean isFeatureEnabled(String featureKey) {
        return this.getAllEnabledFeatures().contains(StringUtils.trim((String)featureKey)) && !this.getAllEnabledFeatures().contains(StringUtils.trim((String)featureKey) + ".disable");
    }

    public static boolean isDarkFeatureEnabled(String featureKey) {
        DarkFeatures darkFeatures = DarkFeatures.getDarkFeaturesManager().getDarkFeatures();
        return darkFeatures.isFeatureEnabled(featureKey);
    }

    @Deprecated(since="9.3", forRemoval=true)
    public static boolean isDarkFeatureEnabled(ConfluenceUser user, String featureKey) {
        return DarkFeatures.isDarkFeatureEnabled(featureKey);
    }

    @Deprecated(since="5.2", forRemoval=true)
    public static boolean isDarkFeatureEnabled(User user, String featureKey) {
        return DarkFeatures.isDarkFeatureEnabled(featureKey);
    }

    private static DarkFeaturesManager getDarkFeaturesManager() {
        return (DarkFeaturesManager)ContainerManager.getComponent((String)"darkFeaturesManager");
    }
}

