/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.settings;

import com.atlassian.confluence.event.events.admin.SiteDarkFeatureDisabledEvent;
import com.atlassian.confluence.event.events.admin.SiteDarkFeatureEnabledEvent;
import com.atlassian.confluence.impl.feature.SiteDarkFeaturesDao;
import com.atlassian.confluence.setup.settings.BuildNumberActivatedDarkFeatures;
import com.atlassian.confluence.setup.settings.DarkFeatures;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.setup.settings.UnknownFeatureException;
import com.atlassian.confluence.setup.settings.VacantDarkFeaturesManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Set;

public class DefaultDarkFeaturesManager
implements DarkFeaturesManager {
    private static final boolean DARK_FEATURES_DISABLED_SYSTEM_WIDE = Boolean.getBoolean("atlassian.darkfeature.disabled");
    private final EventPublisher eventPublisher;
    private final SiteDarkFeaturesDao siteDarkFeaturesDao;
    private final BuildNumberActivatedDarkFeatures buildNumberActivatedDarkFeatures;

    public DefaultDarkFeaturesManager(EventPublisher eventPublisher, SiteDarkFeaturesDao siteDarkFeaturesDao, BuildNumberActivatedDarkFeatures buildNumberActivatedDarkFeatures) {
        this.eventPublisher = eventPublisher;
        this.siteDarkFeaturesDao = siteDarkFeaturesDao;
        this.buildNumberActivatedDarkFeatures = buildNumberActivatedDarkFeatures;
    }

    private Set<String> getSystemEnabledFeatures() {
        return this.getSystemEnabledFeatures(VacantDarkFeaturesManager.ONLY_SYSTEM_FEATURES.getSystemEnabledFeatures(), VacantDarkFeaturesManager.SYSTEM_DISABLED_FEATURES);
    }

    @VisibleForTesting
    Set<String> getSystemEnabledFeatures(Set<String> systemEnabledFeatures, Set<String> systemDisabledFeatures) {
        return Sets.union(systemEnabledFeatures, (Set)Sets.difference(this.buildNumberActivatedDarkFeatures.getActivatedDarkFeatures(), systemDisabledFeatures).immutableCopy());
    }

    private Set<String> getSiteEnabledFeatures() {
        return this.siteDarkFeaturesDao.getSiteEnabledFeatures();
    }

    @Override
    public DarkFeatures getDarkFeatures() {
        return this.getDarkFeaturesAllUsers();
    }

    @Override
    public DarkFeatures getDarkFeaturesAllUsers() {
        if (DARK_FEATURES_DISABLED_SYSTEM_WIDE) {
            return VacantDarkFeaturesManager.NO_FEATURES;
        }
        return new DarkFeatures(this.getSystemEnabledFeatures(), this.getSiteEnabledFeatures());
    }

    @Override
    public DarkFeatures getSiteDarkFeatures() {
        return this.getDarkFeatures(null);
    }

    @Override
    public void enableUserFeature(String featureKey) throws UnknownFeatureException {
        this.throwUnsupportedPerUserOperationException();
    }

    @Override
    public void enableUserFeature(ConfluenceUser user, String featureKey) throws UnknownFeatureException {
        this.throwUnsupportedPerUserOperationException();
    }

    @Override
    public void disableUserFeature(String featureKey) throws UnknownFeatureException {
        this.throwUnsupportedPerUserOperationException();
    }

    @Override
    public void disableUserFeature(ConfluenceUser user, String featureKey) throws UnknownFeatureException {
        this.throwUnsupportedPerUserOperationException();
    }

    @Override
    public DarkFeatures getDarkFeatures(ConfluenceUser user) {
        return this.getDarkFeaturesAllUsers();
    }

    @Override
    public synchronized void enableSiteFeature(String featureKey) throws UnknownFeatureException {
        boolean enabled = this.siteDarkFeaturesDao.enableSiteFeature(featureKey);
        if (enabled) {
            this.eventPublisher.publish((Object)new SiteDarkFeatureEnabledEvent(this, featureKey));
        }
    }

    @Override
    public synchronized void disableSiteFeature(String featureKey) throws UnknownFeatureException {
        boolean disabled = this.siteDarkFeaturesDao.disableSiteFeature(featureKey);
        if (disabled) {
            this.eventPublisher.publish((Object)new SiteDarkFeatureDisabledEvent(this, featureKey));
        }
    }

    private void throwUnsupportedPerUserOperationException() {
        throw new UnsupportedOperationException("This implementation doesn't support per-user dark features.");
    }
}

