/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.struts;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.HtmlUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ActionContext;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.dispatcher.Parameter;
import org.apache.struts2.interceptor.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAwareInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractAwareInterceptor.class);

    public void destroy() {
        log.debug("Destroying Struts interceptor: {}", (Object)this.getClass().getName());
    }

    public void init() {
        log.debug("Initialising Struts interceptor: {}", (Object)this.getClass().getName());
    }

    public abstract String intercept(ActionInvocation var1) throws Exception;

    protected String getParameter(String parameterName) {
        ActionContext context = ActionContext.getContext();
        Parameter o = context.getParameters().get((Object)parameterName);
        if (o == null && context.getServletRequest() != null) {
            return context.getServletRequest().getParameter(parameterName);
        }
        String result = null;
        if (o instanceof Parameter.Empty) {
            result = HtmlUtil.urlDecode(((Parameter.Empty)o).getValue());
        } else if (o instanceof Parameter.Request) {
            result = HtmlUtil.urlDecode(((Parameter.Request)o).getValue());
        }
        return result;
    }

    protected boolean hasParameter(String parameterName) {
        return StringUtils.isNotEmpty((CharSequence)this.getParameter(parameterName));
    }

    protected ConfluenceUser getUser() {
        return AuthenticatedUserThreadLocal.get();
    }
}

