/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.struts;

import com.atlassian.confluence.setup.SetupContext;
import com.atlassian.confluence.setup.struts.ConfluenceStrutsVelocityContext;
import com.atlassian.confluence.setup.velocity.ConfluenceStaticContextItemProvider;
import com.atlassian.confluence.setup.velocity.VelocityContextItemProvider;
import com.atlassian.confluence.util.ConfluenceMockServletRequest;
import com.atlassian.confluence.velocity.context.ChainedVelocityContext;
import com.atlassian.confluence.velocity.context.CompositeContext;
import com.atlassian.confluence.velocity.htmlsafe.ConfluenceEventCartridgeProcessor;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.velocity.htmlsafe.context.EventCartridgeProcessor;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.StrutsException;
import org.apache.struts2.util.ValueStack;
import org.apache.struts2.views.velocity.VelocityManager;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceVelocityManager
implements VelocityManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluenceVelocityManager.class);
    private static final String VELOCITY_PROPERTIES = "velocity.properties";
    private static final VelocityContextItemProvider STATIC_CONTEXT_ITEM_PROVIDER = new ConfluenceStaticContextItemProvider();
    private static final EventCartridgeProcessor CARTRIDGE_PROCESSOR = new ConfluenceEventCartridgeProcessor();
    private VelocityEngine velocityEngine;

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public Context createContext(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        ConfluenceStrutsVelocityContext confluenceContext = new ConfluenceStrutsVelocityContext(ConfluenceVelocityManager.newApplicationContexts(), stack);
        ConfluenceVelocityManager.appendReqResItems((Context)confluenceContext, request, response);
        Optional.ofNullable(stack.getActionContext().getActionInvocation()).ifPresent(arg_0 -> ConfluenceVelocityManager.lambda$createContext$0((Context)confluenceContext, arg_0));
        return ConfluenceVelocityManager.processContextForRendering((Context)confluenceContext);
    }

    public static Context getConfluenceVelocityContext() {
        ChainedVelocityContext context = new ChainedVelocityContext(CompositeContext.composite(ConfluenceVelocityManager.newApplicationContexts()));
        StaticHttpContext httpContext = new StaticHttpContext();
        ConfluenceVelocityManager.appendReqResItems((Context)context, httpContext.getActiveRequest(), httpContext.getActiveResponse());
        return ConfluenceVelocityManager.processContextForRendering((Context)context);
    }

    private static void appendReqResItems(Context context, HttpServletRequest request, HttpServletResponse response) {
        if (request != null) {
            context.put("session", (Object)request.getSession(false));
        }
        context.put("request", Objects.requireNonNullElseGet(request, ConfluenceMockServletRequest::new));
        context.put("response", (Object)response);
    }

    public synchronized void init(ServletContext context) {
        if (this.velocityEngine == null) {
            this.velocityEngine = this.newVelocityEngine(context);
        }
    }

    private VelocityEngine newVelocityEngine(ServletContext context) {
        LOG.info("Creating new VelocityEngine from ServletContext");
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setApplicationAttribute((Object)ServletContext.class.getName(), (Object)context);
        try {
            velocityEngine.init(this.loadConfiguration(context));
        }
        catch (Exception e) {
            throw new StrutsException("Unable to instantiate VelocityEngine", (Throwable)e);
        }
        return velocityEngine;
    }

    private Properties loadConfiguration(ServletContext context) {
        Properties properties = new Properties();
        properties.setProperty("strutsfile.resource.loader.path", context.getRealPath(""));
        try (InputStream in = ConfluenceVelocityManager.class.getClassLoader().getResourceAsStream(VELOCITY_PROPERTIES);){
            LOG.info("Initializing Velocity using {}", (Object)VELOCITY_PROPERTIES);
            properties.load(in);
        }
        catch (IOException e) {
            LOG.warn("Error loading Velocity configuration {}", (Object)VELOCITY_PROPERTIES, (Object)e);
        }
        return properties;
    }

    public static Context processContextForRendering(Context context) {
        EventCartridge cartridge = new EventCartridge();
        cartridge.addEventHandler((EventHandler)((ReferenceInsertionEventHandler)(reference, value) -> {
            LOG.debug("resolving reference [{}]", (Object)reference);
            return value;
        }));
        CARTRIDGE_PROCESSOR.processCartridge(cartridge);
        cartridge.attachToContext(context);
        return context;
    }

    private static List<VelocityContext> newApplicationContexts() {
        return List.of(new VelocityContext(STATIC_CONTEXT_ITEM_PROVIDER.getContextMap()), new VelocityContext(!ContainerManager.isContainerSetup() && SetupContext.get() != null ? Map.of("webResourceManager", SetupContext.get().getBean("webResourceManager"), "languageManager", SetupContext.get().getBean("languageManager")) : ((VelocityContextItemProvider)ContainerManager.getComponent((String)"velocityContextItemProvider", VelocityContextItemProvider.class)).getContextMap()));
    }

    private static /* synthetic */ void lambda$createContext$0(Context confluenceContext, ActionInvocation inv) {
        confluenceContext.put("action", inv.getAction());
    }
}

