/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.velocity;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.setup.velocity.VelocityContextItemProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ClusterContextItemProvider
implements VelocityContextItemProvider {
    private final ResettableLazyReference<ClusterNodeInformation> clusterNodeRef;

    public ClusterContextItemProvider(ClusterManager clusterManager) {
        Preconditions.checkNotNull((Object)clusterManager);
        this.clusterNodeRef = Lazy.resettable(() -> ((ClusterManager)clusterManager).getThisNodeInformation());
    }

    @VisibleForTesting
    void reset() {
        this.clusterNodeRef.reset();
    }

    @Override
    public @NonNull Map<String, Object> getContextMap() {
        ClusterNodeInformation clusterNode = (ClusterNodeInformation)this.clusterNodeRef.get();
        if (clusterNode == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("clusterNodeId", clusterNode.getAnonymizedNodeIdentifier());
        clusterNode.humanReadableNodeName().ifPresent(name -> map.put("clusterNodeName", (String)name));
        return Collections.unmodifiableMap(map);
    }
}

