/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.velocity;

import com.atlassian.confluence.content.render.xhtml.PolicyConfiguredCleaner;
import com.atlassian.confluence.impl.util.DecoratorUtil;
import com.atlassian.confluence.setup.velocity.VelocityContextItemProvider;
import com.atlassian.confluence.util.CookieUtil;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.VelocityUtil;
import com.google.common.collect.ImmutableMap;
import io.atlassian.util.concurrent.Lazy;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ConfluenceStaticContextItemProvider
implements VelocityContextItemProvider {
    private static final Supplier<Map<String, Object>> mapRef = Lazy.callable(ContextItems::createMap);

    @Override
    public @NonNull Map<String, Object> getContextMap() {
        return mapRef.get();
    }

    public static enum ContextItems {
        HTML_UTIL("htmlUtil", () -> HtmlUtil.INSTANCE),
        GENERAL_UTIL("generalUtil", () -> VelocityUtil.INSTANCE),
        STRING_UTILS("stringUtils", StringUtils::new),
        DECORATOR_UTIL("decoratorUtil", DecoratorUtil::new),
        RENDERED_CONTENT_CLEANER("renderedContentCleaner", PolicyConfiguredCleaner::createRenderedContentCleaner),
        COOKIE_UTIL("cookieUtil", () -> CookieUtil.INSTANCE);

        private final String key;
        private final Callable<?> factory;

        private ContextItems(String key, Callable<?> factory) {
            this.key = key;
            this.factory = factory;
        }

        public String getKey() {
            return this.key;
        }

        static Map<String, Object> createMap() throws Exception {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ContextItems item : ContextItems.values()) {
                builder.put((Object)item.key, item.factory.call());
            }
            return builder.build();
        }
    }
}

