/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.velocity;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.datetime.DateFormatService;
import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.datetime.FriendlyDateFormatter;
import com.atlassian.confluence.core.datetime.FriendlyDateFormatterHelper;
import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.setup.settings.GlobalDescriptionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.setup.velocity.VelocityContextItemProvider;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserPreferencesAccessor;
import com.atlassian.confluence.user.UserProfilePictureAccessor;
import com.atlassian.confluence.util.collections.LazyMap;
import com.atlassian.confluence.util.i18n.DocumentationBeanFactory;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.message.MessageManager;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.user.User;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DynamicContextItemProvider
implements VelocityContextItemProvider {
    private final Map<String, Supplier<?>> supplierMap;

    public DynamicContextItemProvider(GlobalSettingsManager globalSettingsManager, GlobalDescriptionManager globalDescriptionManager, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, FormatSettingsManager formatSettingsManager, UserPreferencesAccessor userPreferencesAccessor, DocumentationBeanFactory documentationBeanFactory, DarkFeaturesManager darkFeaturesManager, UserProfilePictureAccessor userProfilePictureAccessor, BootstrapManager bootstrapManager, ConfluenceAccessManager confluenceAccessManager, DateFormatService dateFormatService, AccessModeService accessModeService, PermissionManager permissionManager, LicenseService licenseService, MessageManager messageManager) {
        ApplicationConfiguration appConfig = bootstrapManager.getApplicationConfig();
        Supplier<ConfluenceUser> userRef = AuthenticatedUserThreadLocal::get;
        Supplier<HttpServletRequest> reqRef = ServletContextThreadLocal::getRequest;
        Map.Entry[] entryArray = new Map.Entry[25];
        entryArray[0] = Map.entry("authenticatedUser", userRef);
        entryArray[1] = Map.entry("globalSettings", globalSettingsManager::getGlobalSettings);
        entryArray[2] = Map.entry("globalDescription", globalDescriptionManager::getGlobalDescription);
        entryArray[3] = Map.entry("i18n", () -> ((I18NBeanFactory)i18NBeanFactory).getI18NBean());
        entryArray[4] = Map.entry("darkFeatures", darkFeaturesManager::getDarkFeatures);
        entryArray[5] = Map.entry("docBean", () -> ((DocumentationBeanFactory)documentationBeanFactory).getDocumentationBean());
        entryArray[6] = Map.entry("friendlyDateFormatterHelper", () -> new FriendlyDateFormatterHelper(new FriendlyDateFormatter(new Date(), new DateFormatter(userPreferencesAccessor.getUserPreferences(AuthenticatedUserThreadLocal.get()).getTimeZone(), formatSettingsManager, localeManager)), i18NBeanFactory, localeManager));
        entryArray[7] = Map.entry("userAvatarUriReference", () -> userProfilePictureAccessor.getUserProfilePicture((User)userRef.get()).getUriReference());
        entryArray[8] = Map.entry("isSetupComplete", () -> ((ApplicationConfiguration)appConfig).isSetupComplete());
        entryArray[9] = Map.entry("isAjsLogRendered", () -> ConfluenceSystemProperties.isAjsLogRendered() || appConfig.getBooleanProperty((Object)"ajs.log.rendered"));
        entryArray[10] = Map.entry("isAjsLogVisible", () -> ConfluenceSystemProperties.isAjsLogVisible() || appConfig.getBooleanProperty((Object)"ajs.log.visible"));
        entryArray[11] = Map.entry("isUsingH2", () -> bootstrapManager.getHibernateDialect().contains("H2Dialect"));
        entryArray[12] = Map.entry("isUsingHSQL", () -> StringUtils.containsAny((CharSequence)bootstrapManager.getHibernateDialect(), (CharSequence[])new CharSequence[]{"HSQLDialect", "HSQL2Dialect"}));
        entryArray[13] = Map.entry("dateFormatSetting", formatSettingsManager::getDateFormat);
        entryArray[14] = Map.entry("isUserHasLicensedAccess", () -> confluenceAccessManager.getUserAccessStatus((ConfluenceUser)userRef.get()).hasLicensedAccess());
        entryArray[15] = Map.entry("userLocaleDefaultDatePattern", () -> ((DateFormatService)dateFormatService).getDateFormatPatternForUser());
        entryArray[16] = Map.entry("accessMode", () -> accessModeService.getAccessMode().name());
        entryArray[17] = Map.entry("isExternalUserManagementEnabled", () -> globalSettingsManager.getGlobalSettings().isExternalUserManagement());
        entryArray[18] = Map.entry("isPrintableVersion", () -> reqRef.get() != null && "printable".equalsIgnoreCase(((HttpServletRequest)reqRef.get()).getParameter("decorator")));
        entryArray[19] = Map.entry("isDevMode", ConfluenceSystemProperties::isDevMode);
        entryArray[20] = Map.entry("frontendServiceURL", ConfluenceSystemProperties::getConfluenceFrontendServiceURL);
        entryArray[21] = Map.entry("isUserHasBrowseUsersPermission", () -> permissionManager.hasPermission((ConfluenceUser)userRef.get(), Permission.VIEW, User.class));
        entryArray[22] = Map.entry("languageJs", () -> Language.getJsLang(localeManager.getLocale((User)userRef.get()).toString()));
        entryArray[23] = Map.entry("license", () -> ((LicenseService)licenseService).retrieve());
        entryArray[24] = Map.entry("messageManagerMessages", messageManager::getMessages);
        this.supplierMap = Map.ofEntries(entryArray);
    }

    @Override
    public @NonNull Map<String, Object> getContextMap() {
        return LazyMap.fromSuppliersMap(this.supplierMap);
    }
}

