/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.setup.velocity;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.internal.util.PluginUtils;
import com.atlassian.spring.container.ComponentNotFoundException;
import com.atlassian.spring.container.ContainerManager;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.runtime.resource.loader.util.FileAllowlistHelper;
import org.apache.velocity.runtime.resource.loader.util.FileTypeAllowlistHelper;
import org.apache.velocity.runtime.util.ConfigUtil;

public class DynamicPluginResourceLoader
extends ResourceLoader {
    private PluginAccessor pluginAccessor;
    private FileAllowlistHelper fileAllowlistHelper = null;
    private FileTypeAllowlistHelper fileTypeAllowlistHelper = null;
    private List<String> trustedResourceProtocols = null;

    public void init(ExtendedProperties extendedProperties) {
        this.fileAllowlistHelper = new FileAllowlistHelper(this.rsvc);
        this.fileTypeAllowlistHelper = new FileTypeAllowlistHelper(this.rsvc, "classpath.resource.loader.filetype.allowlist");
        this.trustedResourceProtocols = ConfigUtil.getStrings((RuntimeServices)this.rsvc, (String)"resource.loader.trusted.protocols");
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        URL resourceUrl;
        if (!ContainerManager.isContainerSetup()) {
            throw new ResourceNotFoundException("Spring context is not set yet.");
        }
        while (name.startsWith("/") && name.length() > 1) {
            name = name.substring(1);
        }
        if (this.pluginAccessor == null) {
            try {
                this.pluginAccessor = (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
            }
            catch (ComponentNotFoundException e) {
                throw new ResourceNotFoundException("No plugin manager.");
            }
        }
        if (!this.trustedResourceProtocols.contains((resourceUrl = this.pluginAccessor.getClassLoader().getResource(name)).getProtocol())) {
            if (!this.fileTypeAllowlistHelper.isValidFileType(name)) {
                throw new ResourceNotFoundException("DynamicPluginResourceLoader : banned file type on template " + name);
            }
            if (!this.fileAllowlistHelper.isAllowed(name) && !PluginUtils.isAtlassianDevMode()) {
                this.log.error((Object)("Template is not on the allowlist, but it was asked to be loaded. If you just added the file, first re-install the plugin. The template was: " + name));
                throw new ResourceNotFoundException("DynamicPluginResourceLoader : This template is not allowed: " + name);
            }
        }
        return this.pluginAccessor.getDynamicResourceAsStream(name);
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

