/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces;

import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.spring.container.ContainerManager;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public record AddressableSpace(Space space) implements Addressable
{
    public static AddressableSpace of(Space space) {
        return new AddressableSpace(space);
    }

    @Override
    public long getId() {
        return this.space.getId();
    }

    @Override
    public String getDisplayTitle() {
        return this.space.getDisplayTitle();
    }

    @Override
    public String getUrlPath() {
        String spaceKey = HtmlUtil.urlEncode(StringUtils.defaultString((String)this.space.getKey()), StandardCharsets.UTF_8);
        boolean useReadableUrl = this.getDarkFeatureManager().map(darkFeatureManager -> darkFeatureManager.isEnabledForAllUsers("confluence.readable.url").orElse(Boolean.FALSE)).orElse(false);
        return this.space.isPersonal() ? "/spaces/viewspace.action?key=" + spaceKey : (useReadableUrl ? "/spaces/" + spaceKey + "/overview" : "/display/" + spaceKey);
    }

    private Optional<DarkFeatureManager> getDarkFeatureManager() {
        if (!ContainerManager.isContainerSetup()) {
            return Optional.empty();
        }
        return Optional.ofNullable((DarkFeatureManager)ContainerManager.getComponent((String)"salDarkFeatureManager", DarkFeatureManager.class));
    }

    public URI getDeepLinkUri() {
        Page homePage = this.space.getHomePage();
        if (homePage != null) {
            return URI.create(homePage.getUrlPath());
        }
        return URI.create(this.getUrlPath());
    }

    public String getBrowseUrlPath() {
        return "/pages/listpages.action?key=" + HtmlUtil.urlEncode(this.space.getKey());
    }

    public String getAdvancedTabUrlPath() {
        return "/spaces/viewspacesummary.action?key=" + HtmlUtil.urlEncode(this.space.getKey());
    }

    public String getBlogTabUrlPath() {
        return "/pages/listpages.action?key=" + HtmlUtil.urlEncode(this.space.getKey());
    }
}

