/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceLogo;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.transaction.annotation.Transactional;

@ParametersAreNonnullByDefault
@Transactional
public interface SpaceManager {
    public static final String GLOBAL_LOGO = "global.logo";

    public @NonNull Space createSpace(String var1, String var2, @Nullable String var3, ConfluenceUser var4);

    public @NonNull Space createPersonalSpace(String var1, @Nullable String var2, ConfluenceUser var3);

    public @NonNull Space createPrivatePersonalSpace(String var1, @Nullable String var2, ConfluenceUser var3);

    public @NonNull Space createPrivateSpace(String var1, String var2, @Nullable String var3, ConfluenceUser var4);

    public void saveSpace(Space var1);

    public void saveSpace(Space var1, Space var2);

    @Deprecated
    @Transactional(readOnly=true)
    public @Nullable Space getSpace(long var1);

    @Deprecated
    @Transactional(readOnly=true)
    public @Nullable Space getSpace(@Nullable String var1);

    @Deprecated
    @Transactional(readOnly=true)
    public @Nullable Space getPersonalSpace(@Nullable ConfluenceUser var1);

    default public boolean hasPersonalSpace(@Nullable ConfluenceUser user) {
        return this.getPersonalSpace(user) != null;
    }

    @Deprecated(forRemoval=true)
    @Transactional(readOnly=true)
    public @NonNull List<Space> getAllSpaces();

    @Transactional(readOnly=true)
    public @NonNull List getSpacesContainingPagesEditedBy(@Nullable ConfluenceUser var1);

    @Transactional(readOnly=true)
    public @NonNull List getSpacesContainingCommentsBy(@Nullable ConfluenceUser var1);

    @Transactional(readOnly=true)
    public @NonNull List getAuthoredSpacesByUser(@Nullable ConfluenceUser var1);

    @Transactional(readOnly=true)
    public long findPageTotal(Space var1);

    @Transactional(readOnly=true)
    public int getNumberOfBlogPosts(Space var1);

    @Transactional(readOnly=true)
    public @Nullable String getSpaceFromPageId(long var1);

    @Transactional(readOnly=true)
    public @NonNull List<Space> getSpacesCreatedAfter(Date var1);

    public void ensureSpaceDescriptionExists(Space var1);

    @Transactional(readOnly=true)
    public @NonNull SpaceLogo getLogoForSpace(@Nullable String var1);

    @Transactional(readOnly=true)
    public @NonNull SpaceLogo getLogoForGlobalcontext();

    @Deprecated
    @Transactional(readOnly=true)
    public @NonNull ListBuilder<Space> getSpaces(SpacesQuery var1);

    @Deprecated
    @Transactional(readOnly=true)
    public @NonNull List<Space> getAllSpaces(SpacesQuery var1);

    @Transactional(readOnly=true)
    public @NonNull List<User> getSpaceAdmins(Space var1);

    @Transactional(readOnly=true)
    public @NonNull List<User> getSpaceAdmins(Space var1, int var2);

    public void archiveSpace(Space var1);

    public void unarchiveSpace(Space var1);

    @Transactional(readOnly=true)
    public @NonNull Collection<String> getAllSpaceKeys(SpaceStatus var1);

    default public Message getDefaultHomepageTitle(boolean personal, String spaceTitle) {
        return personal ? Message.getInstance((String)"default.personal.space.homepage.title", (Object[])new Object[]{spaceTitle}) : Message.getInstance((String)"default.space.homepage.title", (Object[])new Object[]{spaceTitle});
    }
}

