/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.UploadedResource;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.struts.multipart.FileUploadException;
import com.atlassian.struts.multipart.UploadedFile;
import java.util.List;
import org.apache.struts2.dispatcher.LocalizedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogoAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(AbstractLogoAction.class);
    protected FileUploadManager fileUploadManager;
    protected AttachmentManager attachmentManager;

    public abstract String doDisableLogo();

    public abstract String doEnableLogo();

    public abstract boolean isLogoDisabled();

    protected abstract ContentEntityObject getContentToAttachLogoTo();

    public abstract String getActionDescriminator();

    protected abstract String getAttachmentName();

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String doDelete() {
        this.attachmentManager.removeAttachmentFromServer(this.attachmentManager.getAttachment(this.getContentToAttachLogoTo(), this.getAttachmentName()));
        return "success";
    }

    @Deprecated(since="8.8.0", forRemoval=true)
    public Attachment getLogo() {
        return this.attachmentManager.getAttachment(this.getContentToAttachLogoTo(), this.getAttachmentName());
    }

    public String doUpload() {
        try {
            List<UploadedFile> uploadedFiles = this.strutsHelper.getUploadedFiles(this.getActiveRequest());
            if (uploadedFiles.isEmpty()) {
                throw new FileUploadException(new LocalizedMessage[0]);
            }
            UploadedFile uploadedFile = uploadedFiles.get(0);
            UploadedResource resource = new UploadedResource(uploadedFile.getFile(), this.getAttachmentName(), uploadedFile.getContentType(), null);
            this.fileUploadManager.storeResource(resource, this.getContentToAttachLogoTo());
            return "success";
        }
        catch (FileUploadException e) {
            String errorMsg = this.getText("could.not.locate.uploaded.logo");
            log.debug(errorMsg, (Throwable)e);
            this.addActionError(errorMsg);
            return "error";
        }
    }

    public void setFileUploadManager(FileUploadManager fileUploadManager) {
        this.fileUploadManager = fileUploadManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }
}

