/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.spaces.actions.AddLabelToSpaceAction;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import java.util.Iterator;
import java.util.List;

public class AddTeamLabelToSpaceAction
extends AddLabelToSpaceAction {
    @Override
    public void performSpaceLabelTransformations() {
        this.setNewTeamLabel(this.addTeamPrefixToAllLabels(this.getNewLabel()));
    }

    @Override
    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String execute() throws Exception {
        return super.execute();
    }

    private String addTeamPrefixToAllLabels(String labelText) {
        StringBuilder result = new StringBuilder();
        List<String> labelNames = LabelUtil.split(labelText);
        Iterator iterator = labelNames.iterator();
        while (iterator.hasNext()) {
            String label = (String)iterator.next();
            result.append(this.addTeamPrefix(label));
            if (!iterator.hasNext()) continue;
            result.append(" ");
        }
        return result.toString();
    }

    private String addTeamPrefix(String label) {
        if (!((String)label).startsWith(LabelParser.TEAM_LABEL_PREFIX)) {
            label = LabelParser.TEAM_LABEL_PREFIX + (String)label;
        }
        return label;
    }
}

