/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.confluence.dmz.spaces.SpaceRemovalLongRunningTask;
import com.atlassian.confluence.impl.space.SpaceRemovalLongRunningTaskFactory;
import com.atlassian.confluence.search.IndexManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAdminAction;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class RemoveSpaceAction
extends AbstractSpaceAdminAction {
    private IndexManager indexManager;
    private LongRunningTaskId taskId;
    private LongRunningTaskManager longRunningTaskManager;
    private SpaceRemovalLongRunningTaskFactory spaceRemovalLongRunningTaskFactory;

    @Override
    public void validate() {
        super.validate();
        if (this.indexManager.isReIndexing()) {
            this.addCannotRemoveSpaceError();
        }
    }

    public String doRemove() throws Exception {
        if (this.getSpace() == null) {
            return "input";
        }
        SpaceRemovalLongRunningTask spaceRemovalLongRunningTask = this.spaceRemovalLongRunningTaskFactory.createTask(this.getSpace(), this.getAuthenticatedUser());
        this.taskId = this.longRunningTaskManager.startLongRunningTask(this.getAuthenticatedUser(), (LongRunningTask)spaceRemovalLongRunningTask);
        return "success";
    }

    private void addCannotRemoveSpaceError() {
        Object baseUrl = this.getGlobalSettings().getBaseUrl();
        if (!((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        this.addActionError(this.getText("com.atlassian.confluence.spaces.actions.RemoveSpaceAction.action.not.possible", new Object[]{(String)baseUrl + "admin/search-indexes.action"}));
    }

    public void setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public LongRunningTaskId getTaskId() {
        return this.taskId;
    }

    public void setLongRunningTaskManager(LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }

    public void setSpaceRemovalLongRunningTaskFactory(SpaceRemovalLongRunningTaskFactory spaceRemovalLongRunningTaskFactory) {
        this.spaceRemovalLongRunningTaskFactory = spaceRemovalLongRunningTaskFactory;
    }
}

