/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.actions;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.SpaceLabelManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceLabelAware;
import com.atlassian.confluence.util.ContentUtils;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.User;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class ViewSpaceSummaryAction
extends AbstractSpaceAction
implements SpaceLabelAware {
    private static final int ADMIN_LIMIT = 7;
    private String name;
    private String description;
    private boolean showAllAdmins;
    private boolean thereAreMoreAdmins;
    private boolean adminLimitExceeded;
    private List<User> adminUsers;
    private List<ConfluenceEntityObject> recentlyUpdatedContent;
    private ContentEntityManager contentEntityManager;
    private CommentManager commentManager;
    private SpaceLabelManager spaceLabelManager;
    private String adminLimitExceededMsg;
    private static final String ATLASSIAN_CONFLUENCE_SHOW_ALL_SPACE_ADMIN_LIMIT = "atlassian.confluence.show.all.space.admin.limit";
    private static final String ADMIN_DISPLAY_LIMIT_EXCEEDED = "admin.display.limit.exceeded";
    private static final int DEFAULT_SHOW_ALL_SPACE_ADMIN_LIMIT = 25;
    private static final Logger log = LoggerFactory.getLogger(ViewSpaceSummaryAction.class);

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        if (this.getSpace() == null) {
            ServletActionContext.getResponse().sendError(404, "Space not found: " + this.getKey());
            return "ERROR";
        }
        this.name = this.getSpace().getName();
        this.description = this.getSpace().getDescription() != null ? this.getSpace().getDescription().getBodyContent().getBody() : "";
        return "success";
    }

    public List<ConfluenceEntityObject> getRecentlyUpdatedContent() {
        if (this.recentlyUpdatedContent == null) {
            Iterator<SpaceContentEntityObject> content = this.contentEntityManager.getRecentlyModifiedEntities(this.getSpace().getKey(), this.getMaxRecentChangesSize());
            Iterator<Comment> comments = this.commentManager.getRecentlyUpdatedComments(this.getSpace(), this.getMaxRecentChangesSize());
            List<ConfluenceEntityObject> updates = ContentUtils.mergeContentObjects(content, comments, this.getMaxRecentChangesSize());
            this.recentlyUpdatedContent = this.getPermittedEntitiesOf(updates);
        }
        return this.recentlyUpdatedContent;
    }

    @Override
    public List<Label> getTeamLabelsOnThisSpace() {
        return this.getSpaceLabelManager().getTeamLabelsOnSpace(this.getSpace().getKey());
    }

    @Override
    public List<Label> getLabelsOnThisSpace() {
        return this.getSpaceLabelManager().getLabelsOnSpace(this.getSpace());
    }

    public int getMaxRecentChangesSize() {
        return this.getUserInterfaceState().getMaxRecentChangesSize();
    }

    @StrutsParameter
    public void setMaxRecentChangesSize(int i) {
        this.getUserInterfaceState().setMaxRecentChangesSize(i);
    }

    public String getName() {
        return this.name;
    }

    @StrutsParameter
    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    @StrutsParameter
    public void setDescription(String description) {
        this.description = description;
    }

    public ContentEntityManager getContentEntityManager() {
        return this.contentEntityManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    public SpaceLabelManager getSpaceLabelManager() {
        return this.spaceLabelManager;
    }

    public void setSpaceLabelManager(SpaceLabelManager spaceLabelManager) {
        this.spaceLabelManager = spaceLabelManager;
    }

    String getEnvironment(String key) {
        return System.getenv(key);
    }

    private int getAdminLimit() {
        int limit = 7;
        try {
            if (this.showAllAdmins) {
                String showAllSpaceAdminLimit = this.getEnvironment(ATLASSIAN_CONFLUENCE_SHOW_ALL_SPACE_ADMIN_LIMIT);
                limit = showAllSpaceAdminLimit != null ? Integer.parseInt(showAllSpaceAdminLimit) : 25;
            }
        }
        catch (NumberFormatException e) {
            log.error("Invalid value for show all space admin limit", (Throwable)e);
            limit = 25;
        }
        return limit;
    }

    public List<User> getSpaceAdmins() {
        if (this.adminUsers == null) {
            int limit = this.getAdminLimit();
            this.adminUsers = this.spaceManager.getSpaceAdmins(this.getSpace(), limit + 1);
            this.thereAreMoreAdmins = false;
            if (this.adminUsers.size() > limit) {
                this.adminUsers = this.adminUsers.subList(0, limit);
                if (!this.showAllAdmins) {
                    this.thereAreMoreAdmins = true;
                } else {
                    this.adminLimitExceeded = true;
                    this.adminLimitExceededMsg = this.getText(ADMIN_DISPLAY_LIMIT_EXCEEDED, Collections.singletonList(limit));
                }
            }
        }
        return this.adminUsers;
    }

    @StrutsParameter
    public void setShowAllAdmins(boolean showAllAdmins) {
        this.showAllAdmins = showAllAdmins;
    }

    public boolean thereAreMoreAdmins() {
        return this.thereAreMoreAdmins;
    }

    public boolean isAdminLimitExceeded() {
        return this.adminLimitExceeded;
    }

    public void setAdminLimitExceeded(boolean adminLimitExceeded) {
        this.adminLimitExceeded = adminLimitExceeded;
    }

    public void setAdminLimitExceededMsg(String adminLimitExceededMsg) {
        this.adminLimitExceededMsg = adminLimitExceededMsg;
    }

    public String getAdminLimitExceededMsg() {
        return this.adminLimitExceededMsg;
    }
}

