/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.spaces.persistence.dao;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.confluence.dmz.spaces.SpacesQueryWithPermissionQueryBuilder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ParametersAreNonnullByDefault
public interface SpaceDao {
    public @Nullable Space getById(long var1);

    public @Nullable Space getSpace(@Nullable String var1);

    public @NonNull List<Space> getSpacesCreatedByUser(@Nullable ConfluenceUser var1);

    public @Nullable Space getPersonalSpace(@Nullable ConfluenceUser var1);

    public @NonNull List<Space> getSpacesContainingPagesEditedByUser(@Nullable ConfluenceUser var1);

    public @NonNull List<Space> getSpacesContainingCommentsByUser(@Nullable ConfluenceUser var1);

    public @NonNull List<Space> getSpacesCreatedOrUpdatedSinceDate(Date var1);

    public int findPageTotal(Space var1);

    public int getNumberOfBlogPosts(Space var1);

    public @NonNull List<Space> getSpacesCreatedAfter(Date var1);

    public @NonNull List<Space> getSpaces(SpacesQueryWithPermissionQueryBuilder var1, int var2, int var3);

    public @NonNull List<Space> getSpaces(SpacesQueryWithPermissionQueryBuilder var1);

    public int countSpaces(SpacesQueryWithPermissionQueryBuilder var1);

    public @Nullable Space getSpaceByContentId(long var1);

    public @NonNull Collection<String> findSpaceKeysWithStatus(String var1);

    public @NonNull String findUniqueVersionOfSpaceKey(String var1);

    public void performOnAll(Consumer<Space> var1);
}

