/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.status.service;

import com.atlassian.confluence.status.service.HttpClientFactory;
import com.atlassian.confluence.status.service.systeminfo.CloudPlatform;
import com.atlassian.confluence.status.service.systeminfo.CloudPlatformMetadata;
import com.atlassian.confluence.status.service.systeminfo.CloudPlatformType;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudPlatformMetadataService {
    private final Logger logger = LoggerFactory.getLogger(CloudPlatformMetadataService.class);
    private final HttpClientFactory httpClientFactory;
    static final int SOCKET_TIMEOUT = 3000;
    static final int CONNECTION_TIMEOUT = 3000;

    public CloudPlatformMetadataService(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = Objects.requireNonNull(httpClientFactory);
    }

    public Optional<CloudPlatformMetadata> getCloudPlatformMetadata(CloudPlatformType platformType) {
        if (platformType == null) {
            return Optional.empty();
        }
        return this.getCloudPlatformMetadata(platformType.getCloudPlatform());
    }

    private String parseInstanceType(CloudPlatform cloudPlatform, HttpEntity entity) {
        String responseBody = "";
        try {
            responseBody = cloudPlatform.parseInstanceType(EntityUtils.toString((HttpEntity)entity, (String)"UTF-8"));
        }
        catch (IOException | RuntimeException | ParseException e) {
            this.logger.debug("Error parsing response body", e);
        }
        return responseBody;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Optional<CloudPlatformMetadata> getCloudPlatformMetadata(CloudPlatform cloudPlatform) {
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setSocketTimeout(3000, TimeUnit.MILLISECONDS).setConnectTimeout(3000L, TimeUnit.MILLISECONDS).build();
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager();
        connectionManager.setConnectionConfig(connectionConfig);
        try (CloseableHttpClient httpClient = this.httpClientFactory.getInstance((HttpClientConnectionManager)connectionManager);){
            CloudPlatformType platformType = cloudPlatform.getPlatformType();
            ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.get((String)cloudPlatform.getInstanceTypeMetadataEndpoint());
            cloudPlatform.getMetadataHeaders().forEach((arg_0, arg_1) -> ((ClassicRequestBuilder)requestBuilder).setHeader(arg_0, arg_1));
            ClassicHttpRequest metadataRequest = requestBuilder.build();
            try {
                CloseableHttpResponse response;
                block19: {
                    response = httpClient.execute(metadataRequest);
                    if (response.getCode() != 200) break block19;
                    CloudPlatformMetadata.Builder builder = CloudPlatformMetadata.builder();
                    builder.cloudPlatform(platformType);
                    builder.instanceType(this.parseInstanceType(cloudPlatform, response.getEntity()));
                    Optional<CloudPlatformMetadata> optional = Optional.of(builder.build());
                    if (response == null) return optional;
                    response.close();
                    return optional;
                }
                try {
                    this.logger.debug("Metadata endpoint status was {}", (Object)response.getCode());
                    return Optional.empty();
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (IOException e) {
                this.logger.debug("Unexpected error trying to reach {} metadata endpoint", (Object)platformType, (Object)e);
                return Optional.empty();
            }
        }
        catch (IOException | IllegalArgumentException e) {
            this.logger.debug("Unexpected error with HttpClient", (Throwable)e);
        }
        return Optional.empty();
    }
}

