/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.status.service;

import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.status.service.HttpClientFactory;
import com.atlassian.confluence.util.http.ConfluenceHttpParameters;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;

class DefaultHttpClientFactory
implements HttpClientFactory {
    private final GlobalSettingsManager settingsManager;

    public DefaultHttpClientFactory(GlobalSettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Override
    public CloseableHttpClient getInstance() {
        ConfluenceHttpParameters confluenceHttpParameters = this.settingsManager.getGlobalSettings().getConfluenceHttpParameters();
        int socketTimeout = confluenceHttpParameters.getSocketTimeout();
        int connectionTimeout = confluenceHttpParameters.getConnectionTimeout();
        ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom();
        if (socketTimeout >= 0) {
            connectionConfigBuilder.setSocketTimeout(socketTimeout, TimeUnit.MILLISECONDS);
        }
        if (connectionTimeout <= 0) {
            connectionConfigBuilder.setConnectTimeout(0L, TimeUnit.MILLISECONDS);
        } else {
            connectionConfigBuilder.setConnectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        }
        ConnectionConfig connectionConfig = connectionConfigBuilder.build();
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager();
        connectionManager.setConnectionConfig(connectionConfig);
        return this.getInstance((HttpClientConnectionManager)connectionManager);
    }

    @Override
    public CloseableHttpClient getInstance(HttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("relaxed").build()).setConnectionManager(connectionManager).disableAutomaticRetries().disableRedirectHandling().evictExpiredConnections().build();
    }
}

