/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.status.service;

import com.atlassian.modzdetector.Modifications;
import com.atlassian.modzdetector.ModzDetector;
import com.atlassian.modzdetector.ModzRegistryException;
import com.atlassian.modzdetector.ResourceAccessor;
import com.atlassian.plugin.servlet.ServletContextFactory;
import java.io.InputStream;
import java.lang.ref.SoftReference;

public class HashRegistryCache {
    private final ModzDetector detector;
    private SoftReference<Modifications> ref;

    public HashRegistryCache(final ServletContextFactory servletContextFactory) {
        this(new ModzDetector(new ResourceAccessor(){

            public InputStream getResourceByPath(String resourceName) {
                if (((String)resourceName).charAt(0) != '/') {
                    resourceName = "/" + (String)resourceName;
                }
                return servletContextFactory.getServletContext().getResourceAsStream((String)resourceName);
            }

            public InputStream getResourceFromClasspath(String resourceName) {
                return this.getClassLoader().getResourceAsStream(resourceName);
            }

            private ClassLoader getClassLoader() {
                return HashRegistryCache.class.getClassLoader();
            }
        }), new SoftReference<Object>(null));
    }

    HashRegistryCache(ModzDetector detector, SoftReference<Modifications> r) {
        this.detector = detector;
        this.ref = r;
    }

    public synchronized Modifications getModifications() throws ModzRegistryException {
        Modifications mods = this.ref.get();
        if (mods == null) {
            mods = this.detector.getModifiedFiles();
            this.ref = new SoftReference<Modifications>(mods);
        }
        return mods;
    }
}

