/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.struts.interceptor;

import com.atlassian.struts.interceptor.RestrictHttpMethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMethodValidationInterceptor
extends RestrictHttpMethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HttpMethodValidationInterceptor.class);
    private static final RestrictHttpMethodInterceptor.SecurityLevel SECURITY_LEVEL = HttpMethodValidationInterceptor.initConfiguredSecurityLevel();

    protected RestrictHttpMethodInterceptor.SecurityLevel getConfiguredSecurityLevel() {
        return SECURITY_LEVEL;
    }

    private static RestrictHttpMethodInterceptor.SecurityLevel initConfiguredSecurityLevel() {
        String securityLevelProp = System.getProperty("confluence.xwork.httpmethods.securitylevel");
        if (securityLevelProp != null) {
            try {
                return RestrictHttpMethodInterceptor.SecurityLevel.valueOf((String)securityLevelProp);
            }
            catch (IllegalArgumentException e) {
                log.error("Invalid security level. Using DEFAULT", (Throwable)e);
            }
        }
        return RestrictHttpMethodInterceptor.SecurityLevel.DEFAULT;
    }
}

