/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.struts.interceptor;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.spring.container.ContainerManager;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.interceptor.AbstractInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupIncompleteInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SetupIncompleteInterceptor.class);
    private final Supplier<BootstrapManager> bootstrapManagerSupplier = MemoizingComponentReference.containerComponent("bootstrapManager");
    private static final Set<String> noRedirectPrefixes = Set.of("/bootstrap", "/setup");
    private static final Set<String> silentRedirects = Set.of("", "index.action");

    public String intercept(ActionInvocation invocation) throws Exception {
        HttpServletRequest request = invocation.getInvocationContext().getServletRequest();
        if (request == null || StringUtils.isBlank((CharSequence)request.getServletPath()) || this.shouldPassThrough(request.getServletPath())) {
            return invocation.invoke();
        }
        if (!this.isSetupComplete()) {
            String servletPath = request.getServletPath();
            if (!silentRedirects.contains(servletPath)) {
                log.warn("Redirecting request to current setup step: {}", (Object)HtmlUtil.htmlEncode(servletPath));
            }
            return "notsetup";
        }
        return invocation.invoke();
    }

    private boolean shouldPassThrough(String servletPath) {
        String actionNameSpace = this.getNamespaceFromServletPath(servletPath);
        return noRedirectPrefixes.stream().anyMatch(actionNameSpace::startsWith) || "/fourohfour.action".equals(servletPath);
    }

    private boolean isSetupComplete() {
        return ContainerManager.isContainerSetup() && this.bootstrapManagerSupplier.get().isSetupComplete();
    }

    private String getNamespaceFromServletPath(String servletPath) {
        return servletPath.substring(0, servletPath.lastIndexOf("/"));
    }
}

