/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.struts.soy;

import com.atlassian.confluence.plugin.struts.PluginAwareActionConfig;
import com.atlassian.confluence.renderer.template.TemplateRenderer;
import com.atlassian.confluence.struts.soy.ActionViewData;
import com.atlassian.confluence.struts.soy.ActionViewDataMappings;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.config.entities.ActionConfig;
import org.apache.struts2.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoyResult
implements Result {
    private static final Logger log = LoggerFactory.getLogger(SoyResult.class);
    private final Supplier<TemplateRenderer> templateRendererRef = MemoizingComponentReference.containerComponent("templateRenderer");
    private String completeModuleKey;
    private String template;
    private String contentType = "text/html";
    private String encoding = "utf-8";
    private String location;

    public void execute(ActionInvocation invocation) throws Exception {
        HttpServletResponse response = invocation.getInvocationContext().getServletResponse();
        if (StringUtils.isNotBlank((CharSequence)this.location)) {
            this.completeModuleKey = StringUtils.substringBefore((String)this.location, (String)"/");
            this.template = StringUtils.substringAfter((String)this.location, (String)"/");
        }
        if (StringUtils.isBlank((CharSequence)this.completeModuleKey)) {
            throw new IllegalArgumentException("completeModuleKey is required");
        }
        if (StringUtils.isBlank((CharSequence)this.template)) {
            throw new IllegalArgumentException("template is required");
        }
        if (this.completeModuleKey.startsWith(":")) {
            ActionConfig actionConfig = invocation.getProxy().getConfig();
            if (!(actionConfig instanceof PluginAwareActionConfig)) {
                throw new IllegalArgumentException("Relative location found but could not resolve it since proxy is not instance of PluginAwareActionConfig");
            }
            this.completeModuleKey = ((PluginAwareActionConfig)actionConfig).getPlugin().getKey() + this.completeModuleKey;
        }
        response.setContentType(this.contentType + "; charset=" + this.encoding);
        PrintWriter writer = response.getWriter();
        try (Ticker ignored = Timers.start((String)("SoyResult: execute(): template: " + this.template));){
            Map<String, Object> data = SoyResult.getData(invocation.getAction(), false);
            Map<String, Object> injectedData = SoyResult.getData(invocation.getAction(), true);
            String templateName = this.template + ".soy";
            if (!ContainerManager.isContainerSetup()) {
                log.error("Container is not setup. Cannot render Soy template {}", (Object)templateName);
            } else {
                this.templateRendererRef.get().renderTo(writer, this.completeModuleKey, templateName, data, injectedData);
            }
        }
        writer.flush();
    }

    static Map<String, Object> getData(Object action, boolean injected) {
        BeanInfo beanInfo;
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            beanInfo = Introspector.getBeanInfo(action.getClass());
        }
        catch (IntrospectionException e) {
            log.debug("Error retrieving javabean properties from class: {}", action.getClass(), (Object)e);
            return data;
        }
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            Object value;
            Method method = propertyDescriptor.getReadMethod();
            if (method == null || !method.isAnnotationPresent(ActionViewData.class) && !method.isAnnotationPresent(ActionViewDataMappings.class)) continue;
            String key = propertyDescriptor.getName();
            try {
                value = method.invoke(action, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.debug("Error retrieving value for method: {}. Skipping.", (Object)method);
                continue;
            }
            if (method.isAnnotationPresent(ActionViewData.class) && method.getAnnotation(ActionViewData.class).injected() == injected) {
                data.put(key, value);
                continue;
            }
            if (!method.isAnnotationPresent(ActionViewDataMappings.class) || method.getAnnotation(ActionViewDataMappings.class).injected() != injected) continue;
            if (!(value instanceof Map)) {
                log.debug("Method return type must be Map. Method: {}", (Object)method);
                continue;
            }
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    log.debug("Skipping non-string keys.");
                    continue;
                }
                data.put((String)entry.getKey(), entry.getValue());
            }
        }
        return data;
    }

    public String getCompleteModuleKey() {
        return this.completeModuleKey;
    }

    public void setCompleteModuleKey(String completeModuleKey) {
        this.completeModuleKey = completeModuleKey;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

