/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.themes;

import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.setup.settings.SpaceSettings;
import com.atlassian.confluence.setup.settings.beans.ColourSchemesSettings;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.AUIDefaultColorScheme;
import com.atlassian.confluence.themes.BaseColourScheme;
import com.atlassian.confluence.themes.ChainedColourScheme;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.themes.events.ColourSchemeChangedEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultColourSchemeManager
implements ColourSchemeManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultColourSchemeManager.class);
    public static final String COLOUR_SCHEME_PLUGIN_SETTINGS_KEY = "atlassian.confluence.colour.scheme";
    private PluginSettingsFactory pluginSettingsFactory;
    private PluginSettings globalPluginSettings;
    private SettingsManager settingsManager;
    private ThemeManager themeManager;
    private EventPublisher eventPublisher;
    private final ConfluenceJsonObjectMapper mapper = new ConfluenceJsonObjectMapper();

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    @Override
    public ColourScheme getDefaultColourScheme() {
        return AUIDefaultColorScheme.getInstance();
    }

    @Override
    public ColourScheme getSpaceColourScheme(Space space) {
        if (space == null) {
            log.error("Trying to retrieve a space colour scheme for a null space.");
            return null;
        }
        return this.getSpaceColourScheme(space.getKey());
    }

    @Override
    public ColourScheme getSpaceColourScheme(String spaceKey) {
        if (!StringUtils.isNotEmpty((CharSequence)spaceKey)) {
            log.error("Trying to retrieve a space colour scheme for a null space.");
            return null;
        }
        ArrayList<ColourScheme> themeList = new ArrayList<ColourScheme>();
        themeList.add(this.getSelectedScheme(spaceKey));
        themeList.add(this.getSelectedScheme(null));
        themeList.add(this.getDefaultColourScheme());
        return new ChainedColourScheme(themeList);
    }

    @Override
    public ColourScheme getGlobalColourScheme() {
        ArrayList<ColourScheme> themeList = new ArrayList<ColourScheme>();
        themeList.add(this.getSelectedScheme(null));
        themeList.add(this.getDefaultColourScheme());
        return new ChainedColourScheme(themeList);
    }

    private ColourScheme getSelectedScheme(String spaceKey) {
        ColourSchemesSettings schemeSettings = this.getColourSchemesSettings(spaceKey);
        if (schemeSettings.getColourSchemeType().equals("theme")) {
            Theme theme;
            Theme theme2 = theme = StringUtils.isBlank((CharSequence)spaceKey) ? this.themeManager.getGlobalTheme() : this.themeManager.getSpaceTheme(spaceKey);
            if (theme != null && theme.getColourScheme() != null) {
                return theme.getColourScheme();
            }
        } else {
            if (schemeSettings.getColourSchemeType().equals("custom")) {
                if (StringUtils.isNotEmpty((CharSequence)spaceKey)) {
                    return this.getSpaceColourSchemeIsolated(spaceKey);
                }
                return this.getGlobalColourSchemeIsolated();
            }
            if (schemeSettings.getColourSchemeType().equals("global") && spaceKey != null) {
                return this.getSelectedScheme(null);
            }
        }
        return null;
    }

    private ColourSchemesSettings getColourSchemesSettings(String spaceKey) {
        if (StringUtils.isNotEmpty((CharSequence)spaceKey)) {
            return this.settingsManager.getSpaceSettings(spaceKey).getColourSchemesSettings();
        }
        return this.settingsManager.getGlobalSettings().getColourSchemesSettings();
    }

    @Override
    public ColourScheme getThemeColourScheme() {
        Theme theme = this.themeManager.getGlobalTheme();
        if (theme == null) {
            return null;
        }
        return theme.getColourScheme();
    }

    @Override
    public ColourScheme getSpaceThemeColourScheme(String spaceKey) {
        Theme theme = this.themeManager.getSpaceTheme(spaceKey);
        if (theme == null) {
            return null;
        }
        return theme.getColourScheme();
    }

    @Override
    public BaseColourScheme getSpaceColourSchemeIsolated(String spaceKey) {
        String colourSchemeJson = (String)this.pluginSettingsFactory.createSettingsForKey(spaceKey).get(COLOUR_SCHEME_PLUGIN_SETTINGS_KEY);
        BaseColourScheme colourScheme = this.mapper.deserializeOrNull(colourSchemeJson, BaseColourScheme.class);
        if (colourScheme == null) {
            colourScheme = new BaseColourScheme(this.getDefaultColourScheme());
        }
        return colourScheme;
    }

    @Override
    public ColourScheme getSpaceColourSchemeCustom(String spaceKey) {
        String colourSchemeJson = (String)this.pluginSettingsFactory.createSettingsForKey(spaceKey).get(COLOUR_SCHEME_PLUGIN_SETTINGS_KEY);
        BaseColourScheme colourScheme = this.mapper.deserializeOrNull(colourSchemeJson, BaseColourScheme.class);
        if (colourScheme == null) {
            colourScheme = new BaseColourScheme(this.getDefaultColourScheme());
        }
        ArrayList<ColourScheme> themeList = new ArrayList<ColourScheme>();
        themeList.add(colourScheme);
        themeList.add(this.getSelectedScheme(null));
        themeList.add(this.getDefaultColourScheme());
        return new ChainedColourScheme(themeList);
    }

    @Override
    public BaseColourScheme getGlobalColourSchemeIsolated() {
        String colourSchemeJson = (String)this.globalPluginSettings.get(COLOUR_SCHEME_PLUGIN_SETTINGS_KEY);
        BaseColourScheme colourScheme = this.mapper.deserializeOrNull(colourSchemeJson, BaseColourScheme.class);
        if (colourScheme == null) {
            colourScheme = new BaseColourScheme(this.getDefaultColourScheme());
        }
        return colourScheme;
    }

    @Override
    public ColourScheme getGlobalColourSchemeCustom() {
        String colourSchemeJson = (String)this.globalPluginSettings.get(COLOUR_SCHEME_PLUGIN_SETTINGS_KEY);
        BaseColourScheme colourScheme = this.mapper.deserializeOrNull(colourSchemeJson, BaseColourScheme.class);
        if (colourScheme == null) {
            colourScheme = new BaseColourScheme(this.getDefaultColourScheme());
        }
        ArrayList<ColourScheme> themeList = new ArrayList<ColourScheme>();
        themeList.add(colourScheme);
        themeList.add(this.getSelectedScheme(null));
        themeList.add(this.getDefaultColourScheme());
        return new ChainedColourScheme(themeList);
    }

    @Override
    public void resetColourScheme(Space space) {
        if (space == null) {
            this.saveGlobalColourScheme(null);
        } else {
            this.saveSpaceColourScheme(space, null);
        }
    }

    @Override
    public synchronized void saveSpaceColourScheme(Space space, BaseColourScheme colourScheme) {
        this.pluginSettingsFactory.createSettingsForKey(space.getKey()).put(COLOUR_SCHEME_PLUGIN_SETTINGS_KEY, (Object)this.mapper.serialize(colourScheme));
        this.eventPublisher.publish((Object)new ColourSchemeChangedEvent(this, true, space.getKey()));
    }

    @Override
    public synchronized void saveGlobalColourScheme(BaseColourScheme colourScheme) {
        this.globalPluginSettings.put(COLOUR_SCHEME_PLUGIN_SETTINGS_KEY, (Object)this.mapper.serialize(colourScheme));
        this.eventPublisher.publish((Object)new ColourSchemeChangedEvent(this, true, null));
    }

    @Override
    public void setColourSchemeSetting(Space space, String value) {
        if (space == null) {
            Settings settings = this.settingsManager.getGlobalSettings();
            ColourSchemesSettings colourSchemesSettings = settings.getColourSchemesSettings();
            String oldSchemeType = colourSchemesSettings.getColourSchemeType();
            colourSchemesSettings.setColourSchemeType(value);
            this.settingsManager.updateGlobalSettings(settings);
            this.eventPublisher.publish((Object)new ColourSchemeChangedEvent(this, oldSchemeType, value, null));
        } else {
            SpaceSettings settings = this.settingsManager.getSpaceSettings(space.getKey());
            ColourSchemesSettings colourSchemesSettings = settings.getColourSchemesSettings();
            String oldSchemeType = colourSchemesSettings.getColourSchemeType();
            colourSchemesSettings.setColourSchemeType(value);
            this.settingsManager.updateSpaceSettings(settings);
            this.eventPublisher.publish((Object)new ColourSchemeChangedEvent(this, oldSchemeType, value, space.getKey()));
        }
    }

    @Override
    public String getColourSchemeSetting(Space space) {
        if (space == null) {
            return this.settingsManager.getGlobalSettings().getColourSchemesSettings().getColourSchemeType();
        }
        return this.settingsManager.getSpaceSettings(space.getKey()).getColourSchemesSettings().getColourSchemeType();
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

