/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.themes;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.themes.StylesheetManager;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.themes.events.StylesheetChangedEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import org.apache.commons.lang3.StringUtils;

public class DefaultStylesheetManager
implements StylesheetManager {
    private ThemeManager themeManager;
    private PluginSettingsFactory settingsFactory;
    private EventPublisher eventPublisher;
    private SpaceManager spaceManager;

    @Override
    public String getSpaceStylesheet(String spaceKey) {
        return this.getSpaceStylesheet(spaceKey, true);
    }

    @Override
    public String getSpaceStylesheet(String spaceKey, boolean shouldLookGlobal) {
        Object val;
        if (!StringUtils.isEmpty((CharSequence)spaceKey) && !StringUtils.isEmpty((CharSequence)this.themeManager.getSpaceThemeKey(spaceKey))) {
            shouldLookGlobal = false;
        }
        if ((val = this.settingsFactory.createSettingsForKey(spaceKey).get("atlassian.confluence.css.resource.custom")) == null && shouldLookGlobal) {
            val = this.settingsFactory.createGlobalSettings().get("atlassian.confluence.css.resource.custom");
        }
        return (String)val;
    }

    @Override
    public String getGlobalStylesheet() {
        return (String)this.settingsFactory.createGlobalSettings().get("atlassian.confluence.css.resource.custom");
    }

    @Override
    public void addGlobalStylesheet(String style) {
        if (StringUtils.isEmpty((CharSequence)style)) {
            this.removeGlobalStylesheet();
            return;
        }
        this.settingsFactory.createGlobalSettings().put("atlassian.confluence.css.resource.custom", (Object)style);
        this.eventPublisher.publish((Object)new StylesheetChangedEvent(this, null, StylesheetChangedEvent.StylesheetChangeType.ADDED));
    }

    @Override
    public void addSpaceStylesheet(String spaceKey, String style) {
        if (this.spaceManager.getSpace(spaceKey) == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)style)) {
            this.removeSpaceStylesheet(spaceKey);
            return;
        }
        this.settingsFactory.createSettingsForKey(spaceKey).put("atlassian.confluence.css.resource.custom", (Object)style);
        this.eventPublisher.publish((Object)new StylesheetChangedEvent(this, spaceKey, StylesheetChangedEvent.StylesheetChangeType.ADDED));
    }

    @Override
    public void removeSpaceStylesheet(String spaceKey) {
        this.settingsFactory.createSettingsForKey(spaceKey).remove("atlassian.confluence.css.resource.custom");
        this.eventPublisher.publish((Object)new StylesheetChangedEvent(this, spaceKey, StylesheetChangedEvent.StylesheetChangeType.REMOVED));
    }

    @Override
    public void removeGlobalStylesheet() {
        this.settingsFactory.createGlobalSettings().remove("atlassian.confluence.css.resource.custom");
        this.eventPublisher.publish((Object)new StylesheetChangedEvent(this, null, StylesheetChangedEvent.StylesheetChangeType.REMOVED));
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.settingsFactory = pluginSettingsFactory;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

