/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.themes;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.plugin.descriptor.LayoutModuleDescriptor;
import com.atlassian.confluence.setup.velocity.DecoratorName;
import com.atlassian.confluence.themes.ThemedDecorator;
import org.apache.struts2.views.velocity.VelocityManager;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityDecorator
implements ThemedDecorator {
    private static final Logger log = LoggerFactory.getLogger(VelocityDecorator.class);
    private String templatePath;
    private String name;
    private String moduleCompleteKey;

    @Override
    public DecoratorName getDecorator() {
        try {
            VelocityDecorator.getVelocityManager().getVelocityEngine().getTemplate(this.templatePath);
            return new DecoratorName(null, this.templatePath);
        }
        catch (ResourceNotFoundException e) {
            log.error("Layout module could not find velocity template:{}", (Object)this.templatePath, (Object)e);
        }
        catch (ParseErrorException e) {
            log.error("Error parsing decorator template:{}", (Object)this.templatePath, (Object)e);
        }
        catch (Exception e) {
            log.error("Error retrieving space decorator:{}", (Object)this.templatePath, (Object)e);
        }
        return null;
    }

    private static VelocityManager getVelocityManager() {
        return (VelocityManager)BootstrapUtils.getBootstrapContext().getBean("velocityManager", VelocityManager.class);
    }

    @Override
    public void init(LayoutModuleDescriptor moduleDescriptor) {
        this.templatePath = moduleDescriptor.getResourceDescriptor("velocity", "decorator").getLocation();
        this.name = moduleDescriptor.getDecoratorPath();
        this.moduleCompleteKey = moduleDescriptor.getCompleteKey();
    }

    @Override
    public String getResourceKey() {
        return this.moduleCompleteKey;
    }

    public String getVelocityTemplatePath() {
        return this.templatePath;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

